#ifndef CLENSFLARE_H_INCLUDED
#define CLENSFLARE_H_INCLUDED

class CNamedObject;
class CModelPlugin;
class CHeadlight;

/*
 *	YtAvf
 */
class CFlareElement{
	friend class CLensFlare;
private:
	int m_Type;				//	^Cv
	float m_Distance;		//	
	float m_Radius;			//	a
	D3DCOLOR m_InnerColor;	//	̐F
	D3DCOLOR m_OuterColor;	//	O̐F
	string m_TexFileName;	//	eNX`t@C
	LPTEX8 m_Texture;		//	eNX`
public:
	char *Read(char *);
	void LoadData();
	bool operator<(const CFlareElement &rhs){
		return m_Distance<rhs.m_Distance;
	}
};

//	q
typedef list<CFlareElement>::iterator IFlareElement;

/*
 *	YtA
 */
class CLensFlare{
private:
	float m_StartAngle;				//	Jnpx (cos)
	float m_Twinkle;				//	_œx
	float m_Inclination;			//	px̌X
	list<CFlareElement> m_Flare;	//	tAXg
public:
	char *Read(char *);
	void LoadData();
	void Render(VEC3, VEC3, VEC3, float, float);
};

/*
 *	zCgAEg
 */
class CWhiteout{
private:
	float m_StartAngle;	//	Jnpx (cos)
	D3DCOLOR m_Color;	//	F
public:
	CWhiteout(){ m_Color = 0; }
	char *Read(char *);
	void Render(VEC3, float);
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	wbhCgCX^X
 */
class CHeadlightInst{
	friend class CHeadlight;
private:
	VEC3 m_RenderPos;			//	_OpW
	VEC3 m_RenderDir;			//	_Op
	CHeadlight *m_Headlight;	//	wbhCg
public:
	CHeadlightInst(VEC3, VEC3, CHeadlight *);
};

//	q
typedef list<CHeadlightInst>::iterator IHeadlightInst;

/*
 *	wbhCg
 */
class CHeadlight{
private:
	static list<CHeadlightInst> ms_RenderList;	//	_OXg
	float m_MaxDistance;	//	ő勗
	VEC3 m_SourceCoord;		//	ʒu
	VEC3 m_Direction;		//	
	CNamedObject *m_Link;	//	ڑIuWFNg
	CLensFlare m_LensFlare;	//	YtA
public:
	static void InitRenderList();
	static void RenderAll();
	char *Read(char *, CModelPlugin *);
	void LoadData();
	bool Register();
	void Render(CHeadlightInst *);
};

//	q
typedef list<CHeadlight>::iterator IHeadlight;

#endif
