#ifndef CDRAGCONTAINER_H_INCLUDED
#define CDRAGCONTAINER_H_INCLUDED

const int DRAG_THD = FONT_HEIGHT/2;

//	q
typedef list<DWORD>::iterator IDWORD;

//	hbO^Cv
typedef enum{
	DRAG_NONE = 0,	//	s
	DRAG_PLUGIN,	//	vOCEfBNg
	DRAG_INSERT,	//	ꃊXg}̂
} DRAGTYPE;

/*
 *	hbORei
 */
class CDragContainer{
	friend class CDragInterface;
private:
	static CDragContainer *ms_Drag;	//	hbO
	DRAGTYPE m_Type;			//	^Cv
	list<DWORD> m_Data;			//	f[^
	CDragInterface *m_Owner;	//	L
public:
	static void BeginDrag(DRAGTYPE, CDragInterface *);
	static void EndDrag();
	static bool IsDragging(){ return !!ms_Drag; }
	static void Insert(DWORD);
	static void Render();
	static list<DWORD> &GetData(){ return ms_Drag->m_Data; }
	static DRAGTYPE GetType(){ return ms_Drag ? ms_Drag->m_Type : DRAG_NONE; }
	static CDragInterface *GetOwner(){ return ms_Drag ? ms_Drag->m_Owner : NULL; }
	CDragContainer(DRAGTYPE, CDragInterface *);
	void InsertData(DWORD);
	void RenderDragItem();
};

/*
 *	hbO\C^[tFCX
 */
class CDragInterface{
protected:
public:
	virtual void RenderDragItem() = 0;
};

#endif CDRAGCONTAINER_H_INCLUDED
