#ifndef CCURSOR_H_INCLUDED
#define CCURSOR_H_INCLUDED

/*
 *	J[\NX
 */
class CCursor{
private:
	int m_State;	//	
	int m_Resizing;	//	TCY
	float m_Alpha;	//	At@l
	POINT m_Pos;	//	W
	POINT m_Delta;	//	S̍
public:
	void Init();
	void Clip();
	void Center();
	void Render();
	void ScanInput(bool forcelock = false);
	void FixCursor();
	void SetResize(int r){ if(m_Resizing<-1) m_Resizing = r; }
	POINT GetPos(){ return m_Pos; }
	POINT GetDelta(){ return m_Delta; }
	bool CheckDrag();
	VEC3 GetVEC3(){ return VEC3((float)m_Pos.x, (float)m_Pos.y, 0.0f); }
	void Lock();
	void Release();
	bool IsLock(){ return !!m_State; }
};

//	OO[o
extern CCursor g_Cursor;

#endif
