#ifndef CCAMERA_H_INCLUDED
#define CCAMERA_H_INCLUDED

#include "CModelInst.h"

/*
 *	J
 */
class CCamera{
private:
	static CCamera *ms_CurrentCamera;	//	݂̃J
	int m_LeftState;					//	{^
	int m_MiddleState;					//	{^
	int m_RightState;					//	E{^
	int m_PrintInfoTime;				//	\
	float m_Head, m_Pitch;				//	px
//	float m_Bank;						//	oNgp
	float m_Dist;						//	
	float m_Wheel;						//	zC[
	float m_UpDown;						//	㉺ړ
	float m_DefDist;					//	苗
	float m_MinDist, m_MaxDist;			//	ŏEő勗
	float m_FieldOfView;				//	p
	float m_FieldOfViewEffect;			//	p
	float m_AutoZoomBaseDist;			//	Y[
	float m_FocusSpeed;					//	tH[JXߑx
	bool m_LightSwitch;					//	Ɩ ON/OFF
	bool m_LinkLight;					//	ƖA
	bool m_ClipRect;					//	Nbvݒ
	bool m_LockPos;						//	ʒuŒ
	bool m_AutoZoom;					//	Y[
	int m_LocalFocus;					//	[J
	VEC3 m_Focus;						//	_
	VEC3 m_FocusTarget;					//	tH[JXړ
	VEC3 m_CameraPos;					//	JW
	VEC3 m_LightDir;					//	Ɩpx
	CDetectInfo m_FocusInfo;			//	ڏ
public:
	static CCamera *GetCurrentCamera(){ return ms_CurrentCamera; }
	void Init(float, float, float, bool);
	void ResetCamera(float head = -0.25f*D3DX_PI,
		float pitch = 0.25f*D3DX_PI, float bank = 0.0f, float dist = -1.0f);
	void SetCenter(){ m_Focus = V3ZERO; }
	float GetFieldOfView(){ return m_FieldOfView; }
	VEC3 GetFocus(){ return m_Focus; }
	void SetFocus(VEC3 f){ m_Focus = f; }
	void SetFocusTarget(VEC3, float);
	CNamedObject *GetFocusObject(){ return m_FocusInfo.GetObject(); }
	CModelInst *GetFocusInst(){ return m_FocusInfo.GetModelInst(); }
	CPartsInst *GetFocusParts(){ return m_FocusInfo.GetPartsInst(); }
	void SetFocusInfo(CDetectInfo &);
	bool GetLockPos(){ return m_LockPos; }
	void SetLockPos(bool l){ m_LockPos = l; BeginPrint(); }
	bool GetAutoZoom(){ return m_AutoZoom; }
	void SetAutoZoom(bool);
	int GetLocalFocus(){ return m_LocalFocus; }
	void SetLocalFocus(int, CObject *tlocal = NULL);
	float GetDist(){ return m_Dist; }
	void ResetLight();
	void SwitchLight(bool f){ m_LightSwitch = f; }
	bool IsLightOn(){ return m_LightSwitch; }
	void LinkLight(bool);
	bool IsLightLinked(){ return m_LinkLight; }
	void InvCalcParam(CObject *tlocal = NULL);
	void Select();
	void Apply(bool, CObject *tlocal = NULL);
	void ApplyProjection(float, CObject *tlocal = NULL);
	void BeginPrint(){ m_PrintInfoTime = MAXFPS*2; }
	void PrintInfo(bool ext = false);
	void ControlLocal(CObject *tlocal = NULL);
	int ScanInput(int, CObject *tlocal = NULL);
	void Slide(int, CObject *tlocal = NULL);
	char *Read(char *);
	void Save(FILE *, string indent = "\t\t");
};

//	OO[o
extern float g_FovRatio;

#endif
