/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.joran.spi.NoAutoStart;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicyBase;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.SizeAndTimeBasedArchiveRemover;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoAutoStart
public class SizeAndTimeBasedFNATP<E>
extends TimeBasedFileNamingAndTriggeringPolicyBase<E> {
    int currentPeriodsCounter = 0;
    FileSize maxFileSize;
    String maxFileSizeAsString;
    private int invocationCounter;

    @Override
    public void start() {
        super.start();
        this.archiveRemover = new SizeAndTimeBasedArchiveRemover(this.tbrp.fileNamePattern, this.rc);
        if (this.tbrp.getParentsRawFileProperty() == null) {
            String regex = this.tbrp.fileNamePattern.toRegex(this.dateInCurrentPeriod);
            String stemRegex = FileFilterUtil.afterLastSlash(regex);
            this.computeCurrentPeriodsHighestCounterValue(stemRegex);
        }
        this.started = true;
    }

    void computeCurrentPeriodsHighestCounterValue(String stemRegex) {
        File file = new File(this.getCurrentPeriodsFileNameWithoutCompressionSuffix());
        File parentDir = file.getParentFile();
        File[] matchingFileArray = FileFilterUtil.filesInFolderMatchingStemRegex(parentDir, stemRegex);
        if (matchingFileArray == null || matchingFileArray.length == 0) {
            return;
        }
        FileFilterUtil.reverseSortFileArrayByName(matchingFileArray);
        this.currentPeriodsCounter = FileFilterUtil.extractCounter(matchingFileArray[0], stemRegex);
    }

    @Override
    public boolean isTriggeringEvent(File activeFile, E event) {
        long time = this.getCurrentTime();
        if (time >= this.nextCheck) {
            Date dateInElapsedPeriod = this.dateInCurrentPeriod;
            this.elapsedPeriodsFileName = this.tbrp.fileNamePatternWCS.convertMultipleArguments(dateInElapsedPeriod, this.currentPeriodsCounter);
            this.currentPeriodsCounter = 0;
            this.updateDateInCurrentPeriod(time);
            this.computeNextCheck();
            return true;
        }
        if ((this.invocationCounter++ & 0xF) != 15) {
            return false;
        }
        if (activeFile.length() >= this.maxFileSize.getSize()) {
            this.elapsedPeriodsFileName = this.tbrp.fileNamePatternWCS.convertMultipleArguments(this.dateInCurrentPeriod, this.currentPeriodsCounter);
            ++this.currentPeriodsCounter;
            return true;
        }
        return false;
    }

    @Override
    public String getCurrentPeriodsFileNameWithoutCompressionSuffix() {
        return this.tbrp.fileNamePatternWCS.convertMultipleArguments(this.dateInCurrentPeriod, this.currentPeriodsCounter);
    }

    public String getMaxFileSize() {
        return this.maxFileSizeAsString;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSizeAsString = maxFileSize;
        this.maxFileSize = FileSize.valueOf(maxFileSize);
    }
}

