// Main.cpp
// 2008/12/16

#include "StdAfx.h"

#include "QAXDecoder.h"

#include "WaveWriter.h"

static void Run(int argc, wchar_t* argv[]);

int wmain(int argc, wchar_t* argv[], wchar_t* envp[])
{
	HRESULT hRslt = CoInitialize(0);
	if (FAILED(hRslt)) {
		return -1;
	}

	if (!QAX::Initialize()) {
		return -1;
	}

	try {
		Run(argc, argv);

	} catch (QAX::Exception& e) {
		std::string msg = e.ToString();
		printf("Error: %s\n", msg.c_str());
	}

	CoUninitialize();

	return 0;
}

static void Decode(QAX::QDecoderOutput* output, LPCWSTR outPath)
{
	const UINT32 samps = 1024;
	INT16 buffer[samps * 2];

	UINT32 samples = 0;

	QAX::WaveWriter w;

	QAX::QDecoderSpec spec = output->GetDecoderSpec();

	w.Create(
		outPath,
		spec.Channels,
		spec.SamplingRate);

	try {
		for (; ; ) {
			UINT32 count = output->Decode(
				buffer,
				samps);
			if (count == 0) {
				break;
			}

			w.Write(
				buffer,
				count * spec.Channels * 2);

			samples += count;
		}

#if 0
		output->Seek(181908);

		for (; ; ) {
			UINT32 count = output->Decode(
				buffer,
				samps);
			if (count == 0) {
				break;
			}

			w.Write(
				buffer,
				count * spec.Channels * 2);

			samples += count;
		}
#endif

	} catch (...) {
		w.Close();
		throw;
	}

	w.Close();

	printf("Samples: %d\n", samples);
}

std::string ToUTF8(const std::wstring& text)
{
	std::string utf8;

	INT32 blen = WideCharToMultiByte(
		CP_UTF8,
		0,
		text.c_str(),
		text.size(),
		0,
		0,
		0,
		0);
	if (blen > 0) {
		CHAR* bid = new CHAR[blen];
		blen = WideCharToMultiByte(
			CP_UTF8,
			0,
			text.c_str(),
			text.size(),
			bid,
			blen,
			0,
			0);

		utf8 = std::string(bid, blen);

		delete[] bid;
	}

	return utf8;
}

void Run(int argc, wchar_t* argv[])
{
	LPCWSTR inPath  = 0;
	LPCWSTR outPath = 0;

	std::wstring name;

	if (argc != 4) {
		puts("QAXSample [qax File] [name] [wave File]");
		puts("QAXSample -qas [qas File] [wave File]");
		return;
	}

	bool qas = false;

	if (_wcsicmp(argv[1], L"-qas") == 0) {
		inPath  = argv[2];
		outPath = argv[3];

		qas = true;

	} else {
		inPath  = argv[1];
		name    = argv[2];
		outPath = argv[3];
	}

	QAX::CompPtr<QAX::QDecoderFactory> factory = QAX::QDecoderFactoryCreate();

	if (qas) {
		QAX::CompPtr<IStream> stream = QAX::StreamReaderCreate(inPath);

		QAX::CompPtr<QAX::QDecoderOutput> output = QAX::QASDecoderOutputCreate(
			factory,
			stream);
		if (output != 0) {
			Decode(output, outPath);
		}

	} else {
		QAX::CompPtr<QAX::QFileMapping> fileMapping = QAX::QFileMappingCreate(inPath);

		QAX::CompPtr<QAX::QDecoder> decoder = QAX::QDecoderCreate(
			factory,
			fileMapping);

		std::string id = ToUTF8(name);
		QAX::CompPtr<QAX::QDecoderOutput> output = decoder->CreateOutput(id.c_str());
		if (output != 0) {
			Decode(output, outPath);
		}
	}
}

