// QFilter.h
// 2009/08/21

#pragma once

/* */

// {B72ABE74-E35E-4ACA-AACD-4A7E13E7AA65}
DEFINE_GUID(CLSID_QDSAudio,
	0xb72abe74, 0xe35e, 0x4aca, 0xaa, 0xcd, 0x4a, 0x7e, 0x13, 0xe7, 0xaa, 0x65);

/* */

// QFilter
[ uuid("B72ABE74-E35E-4ACA-AACD-4A7E13E7AA65") ]
class ATL_NO_VTABLE QFilter :
	public ATL::CComObjectRootEx<ATL::CComMultiThreadModel>,
	public ATL::CComCoClass<QFilter, &CLSID_QDSAudio>,

	public IBaseFilter,
	public IMediaSeeking,
	public IAMFilterMiscFlags,

	public QPinHost {

	ATL::CComCriticalSection m_cs;

	ATL::CComPtr<IReferenceClock> m_Clock;

	IFilterGraph* m_pFGraph; /* weak */

	ATL::CStringW m_Name;

	QReader* m_pReader;

	QStreamer* m_pStreamer;

	enum {
		PID_Audio = 0,
		PINS
	};

	IPin* m_Pins[PINS];

	QPinAudio* m_pPinAudio;

	FILTER_STATE m_state;

	INT64 m_StartPos;

public:

	DECLARE_NOT_AGGREGATABLE(QFilter)

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	BEGIN_COM_MAP(QFilter)
		COM_INTERFACE_ENTRY(IPersist)
		COM_INTERFACE_ENTRY(IMediaFilter)
		COM_INTERFACE_ENTRY(IBaseFilter)
		COM_INTERFACE_ENTRY(IMediaSeeking)
		COM_INTERFACE_ENTRY(IAMFilterMiscFlags)
	END_COM_MAP()

public:

	QFilter() :
		m_pReader(0),
		m_pStreamer(0),
		m_pPinAudio(0),
		m_state(State_Stopped),
		m_StartPos(-1)
	{
		memset(m_Pins, 0, sizeof(m_Pins));
	}

	~QFilter()
	{
		delete m_pReader;
	}

	HRESULT FinalConstruct()
	{
		ATLTRACE("QFilter::FinalConstruct()\n");

		HRESULT hRslt = m_cs.Init();
		if (FAILED(hRslt)) {
			return hRslt;
		}

		{
			ATL::CComObject<QPinAudio>* pin = 0;
			HRESULT hRslt = ATL::CComObject<QPinAudio>::CreateInstance(&pin);
			if (FAILED(hRslt)) {
				return hRslt;
			}

			pin->Init(this, this, L"Audio");

			hRslt = pin->QueryInterface(m_Pins + PID_Audio);
			if (FAILED(hRslt)) {
				delete pin;
				return hRslt;
			}

			m_pPinAudio = pin;
		}

		return S_OK;
	}

	void FinalRelease()
	{
		ATLTRACE("QFilter::FinalRelease()\n");

		for (INT32 i = 0; i < PINS; i++) {
			if (m_Pins[i] != 0) {
				m_Pins[i]->Release();
			}
		}

		m_cs.Term();
	}

	/* */

	HRESULT OpenVorbis(LPCWSTR path)
	{
		QVorbisReader* p = new QVorbisReader();
		if (!p->Open(path)) {
			delete p;
			return VFW_E_NOT_FOUND;
		}

		m_pReader = p;

		HRESULT hRslt = Setup();
		if (FAILED(hRslt)) {
			return hRslt;
		}

		return S_OK;
	}

	HRESULT OpenVorbis(IStream* p)
	{
		QVorbisReader* r = new QVorbisReader();
		if (!r->Open(p)) {
			delete r;
			return VFW_E_NOT_FOUND;
		}

		m_pReader = r;

		HRESULT hRslt = Setup();
		if (FAILED(hRslt)) {
			return hRslt;
		}

		return S_OK;
	}

	/* */

	HRESULT OpenTTA(LPCWSTR path)
	{
		QTTAReader* p = new QTTAReader();
		if (!p->Open(path)) {
			delete p;
			return VFW_E_NOT_FOUND;
		}

		m_pReader = p;

		HRESULT hRslt = Setup();
		if (FAILED(hRslt)) {
			return hRslt;
		}

		return S_OK;
	}

	HRESULT OpenTTA(IStream* p)
	{
		QTTAReader* r = new QTTAReader();
		if (!r->Open(p)) {
			delete r;
			return VFW_E_NOT_FOUND;
		}

		m_pReader = r;

		HRESULT hRslt = Setup();
		if (FAILED(hRslt)) {
			return hRslt;
		}

		return S_OK;
	}

	/* */

	void SetupLoopPoint(INT64 pos)
	{
		if (m_pReader != 0) {
			m_pReader->SetupLoopPoint(pos);
		}
	}

	/* */

private:

	/* */

	HRESULT Setup()
	{
		QReader::Format fmt = m_pReader->GetFormat();

		m_pPinAudio->SetupAudioFormat(
			fmt.Channels,
			fmt.SamplingRate);

		return S_OK;
	}

	/* */

public:

	/* QPinHost */

	virtual ATL::CComCriticalSection& FilterCSec()
	{
		return m_cs;
	}

	virtual bool IsRunning()
	{
		return (m_state != State_Stopped);
	}

	/* IPersist */

	STDMETHOD(GetClassID)(
		LPCLSID pClassID)
	{
		ATLTRACE("QFilter::GetClassID()\n");

		if (pClassID == 0) {
			return E_INVALIDARG;
		}

		*pClassID = __uuidof(QFilter);

		return S_OK;
	}

	/* IMediaFilter */

	STDMETHOD(Stop)(void)
	{
		ATLTRACE("QFilter::Stop()\n");

		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		HRESULT hRslt = StopStreaming();
		if (FAILED(hRslt)) {
			return hRslt;
		}

		m_state = State_Stopped;

		return S_OK;
	}

	STDMETHOD(Pause)(void)
	{
		ATLTRACE("QFilter::Pause()\n");

		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		HRESULT hRslt = StartStreaming();
		if (FAILED(hRslt)) {
			return hRslt;
		}

		m_state = State_Paused;

		return S_OK;
	}

	STDMETHOD(Run)(REFERENCE_TIME tStart)
	{
		ATLTRACE("QFilter::Run()\n");

		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		HRESULT hRslt = StartStreaming();
		if (FAILED(hRslt)) {
			return hRslt;
		}

		m_state = State_Running;

		return S_OK;
	}

	STDMETHOD(GetState)(
		DWORD         /* dwMilliSecsTimeout */,
		FILTER_STATE* State)
	{
		ATLTRACE("QFilter::GetState()\n");

		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		if (State == 0) {
			return E_INVALIDARG;
		}

		*State = m_state;

		return S_OK;
	}

	STDMETHOD(SetSyncSource)(IReferenceClock* pClock)
	{
		ATLTRACE("QFilter::SetSyncSource()\n");

		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		m_Clock = pClock;

		return S_OK;
	}

	STDMETHOD(GetSyncSource)(IReferenceClock** pClock)
	{
		ATLTRACE("QFilter::GetSyncSource()\n");

		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		if (pClock == 0) {
			return E_INVALIDARG;
		}

		HRESULT hRslt = m_Clock.CopyTo(pClock);
		if (FAILED(hRslt)) {
			return hRslt;
		}

		return S_OK;
	}

	/* IBaseFilter */

	STDMETHOD(EnumPins)(IEnumPins** ppEnum)
	{
		ATLTRACE("QFilter::EnumPins()\n");

		if (ppEnum == 0) {
			return E_INVALIDARG;
		}

		HRESULT hRslt = QEnumPins::Create(m_Pins, m_Pins + PINS, static_cast<IBaseFilter*>(this), ppEnum);
		if (FAILED(hRslt)) {
			return hRslt;
		}

		return S_OK;
	}

	STDMETHOD(FindPin)(
		LPCWSTR Id,
		IPin**  ppPin)
	{
		ATLTRACE("QFilter::FindPin()\n");

		if (Id == 0 || ppPin == 0) {
			return E_INVALIDARG;
		}

		IPin* pin = 0;

		if (wcscmp(Id, L"Audio") == 0) {
			pin = m_Pins[PID_Audio];
		}

		*ppPin = pin;

		if (pin == 0) {
			return VFW_E_NOT_FOUND;
		}

		pin->AddRef();

		return S_OK;
	}

	STDMETHOD(QueryFilterInfo)(
		FILTER_INFO* pInfo)
	{
		ATLTRACE("QFilter::QueryFilterInfo()\n");

		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		if (pInfo == 0) {
			return E_INVALIDARG;
		}

		SIZE_T len = m_Name.GetLength();
		if (len > MAX_FILTER_NAME - 1) {
			len = MAX_FILTER_NAME - 1;
		}
		wcsncpy_s(pInfo->achName, MAX_FILTER_NAME, m_Name, len);

		pInfo->pGraph = m_pFGraph;
		if (m_pFGraph != 0) {
			m_pFGraph->AddRef();
		}

		return S_OK;
	}

	STDMETHOD(JoinFilterGraph)(
		IFilterGraph* pGraph,
		LPCWSTR       pName)
	{
		ATLTRACE("QFilter::JoinFilterGraph()\n");

		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		m_pFGraph = pGraph; /* weak */

		if (pGraph != 0) {
			if (pName != 0) {
				m_Name = pName;
			} else {
				m_Name = L"QDSAudio";
			}

		} else {
			m_Name.Empty();
		}

		return S_OK;
	}

	STDMETHOD(QueryVendorInfo)(
		LPWSTR* pVendorInfo)
	{
		ATLTRACE("QFilter::QueryVendorInfo()\n");

		if (pVendorInfo == 0) {
			return E_INVALIDARG;
		}

		LPCWSTR NAME = L"Project Quilla";

		*pVendorInfo = static_cast<LPWSTR>(CoTaskMemAlloc((wcslen(NAME) + 1) * sizeof(WCHAR)));
		if (*pVendorInfo == 0) {
			return E_OUTOFMEMORY;
		}

		memcpy(*pVendorInfo, NAME, (wcslen(NAME) + 1) * sizeof(WCHAR));

		return S_OK;
	}

	/* IMediaSeeking */

	STDMETHOD(GetCapabilities)(
		DWORD* pCapabilities)
	{
		if (pCapabilities == 0) {
			return E_INVALIDARG;
		}

		*pCapabilities =
			AM_SEEKING_CanSeekAbsolute  |
			AM_SEEKING_CanSeekForwards  |
			AM_SEEKING_CanSeekBackwards |
			AM_SEEKING_CanGetDuration;

		return S_OK;
	}

	STDMETHOD(CheckCapabilities)(
		DWORD* pCapabilities)
	{
		if (pCapabilities == 0) {
			return E_INVALIDARG;
		}

		DWORD c0 = *pCapabilities;

		DWORD cap = 0;
		GetCapabilities(&cap);

		*pCapabilities &= cap;

		if ((cap & c0) != cap) {
			return S_FALSE;
		}

		return S_OK;
	}

	STDMETHOD(IsFormatSupported)(
		const GUID* pFormat)
	{
		if (pFormat == 0) {
			return E_INVALIDARG;
		}

		if (*pFormat != TIME_FORMAT_MEDIA_TIME) {
			return S_FALSE;
		}

		return S_OK;
	}

	STDMETHOD(QueryPreferredFormat)(
		GUID* pFormat)
	{
		if (pFormat == 0) {
			return E_INVALIDARG;
		}

		*pFormat = TIME_FORMAT_MEDIA_TIME;

		return S_OK;
	}

	STDMETHOD(GetTimeFormat)(
		GUID* pFormat)
	{
		if (pFormat == 0) {
			return E_INVALIDARG;
		}

		*pFormat = TIME_FORMAT_MEDIA_TIME;

		return S_OK;
	}

	STDMETHOD(IsUsingTimeFormat)(
		const GUID* pFormat)
	{
		if (pFormat == 0) {
			return E_INVALIDARG;
		}

		if (*pFormat != TIME_FORMAT_MEDIA_TIME) {
			return S_FALSE;
		}

		return S_OK;
	}

	STDMETHOD(SetTimeFormat)(
		const GUID* pFormat)
	{
		if (pFormat == 0) {
			return E_INVALIDARG;
		}

		if (*pFormat != TIME_FORMAT_MEDIA_TIME) {
			return E_INVALIDARG;
		}

		return S_OK;
	}

	STDMETHOD(GetDuration)(
		LONGLONG* pDuration)
	{
		if (pDuration == 0) {
			return E_INVALIDARG;
		}

		if (m_pReader != 0) {
			*pDuration = m_pReader->GetDuration();
		} else {
			*pDuration = 0;
		}

		return S_OK;
	}

	STDMETHOD(GetStopPosition)(
		LONGLONG* /* pStop */)
	{
		return E_NOTIMPL;
	}

	STDMETHOD(GetCurrentPosition)(
		LONGLONG* /* pCurrent */)
	{
		return E_NOTIMPL;
	}

	STDMETHOD(ConvertTimeFormat)(
		LONGLONG*   /* pTarget*/,
		const GUID* /* pTargetFormat */,
		LONGLONG    /* Source */,
		const GUID* /* pSourceFormat */)
	{
		return E_NOTIMPL;
	}

	STDMETHOD(SetPositions)(
		LONGLONG* pCurrent,
		DWORD     dwCurrentFlags,
		LONGLONG* pStop,
		DWORD     dwStopFlags)
	{
		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		switch (dwCurrentFlags & AM_SEEKING_PositioningBitsMask) {
		case AM_SEEKING_NoPositioning:
			break;

		case AM_SEEKING_AbsolutePositioning:
		{
			if (pCurrent == 0) {
				return E_INVALIDARG;
			}

			INT64 pos = *pCurrent;

			if (m_pStreamer != 0) {
				m_pStreamer->BeginFlush();
				m_pStreamer->RequestSeek(pos);
				m_pStreamer->RequestStart();

			} else {
				m_StartPos = pos;
			}

			break;
		}

		default:
			return E_INVALIDARG;
		}

		switch (dwStopFlags & AM_SEEKING_PositioningBitsMask) {
		case AM_SEEKING_NoPositioning:
			break;

		default:
			return E_INVALIDARG;
		}

		return S_OK;
	}

	STDMETHOD(GetPositions)(
		LONGLONG* /* pCurrent */,
		LONGLONG* /* pStop */)
	{
		return E_NOTIMPL;
	}

	STDMETHOD(GetAvailable)(
		LONGLONG* /* pEarliest */,
		LONGLONG* /* pLatest */)
	{
		return E_NOTIMPL;
	}

	STDMETHOD(SetRate)(
		double /* dRate */)
	{
		return E_NOTIMPL;
	}

	STDMETHOD(GetRate)(
		double* /* pdRate */)
	{
		return E_NOTIMPL;
	}

	STDMETHOD(GetPreroll)(
		LONGLONG* /* pllPreroll */)
	{
		return E_NOTIMPL;
	}

	/* IAMFilterMiscFlags */

	STDMETHOD_(ULONG, GetMiscFlags)()
	{
		ATLTRACE("QFilter::GetMiscFlags()\n");

		return AM_FILTER_MISC_FLAGS_IS_SOURCE;
	}

	/* */

private:

	/* */

	HRESULT StartStreaming()
	{
		if (m_pStreamer == 0) {
			m_pStreamer = new QStreamer(m_pReader);

			HRESULT hRslt = m_pStreamer->Initialize();
			if (FAILED(hRslt)) {
				return hRslt;
			}

			hRslt = m_pStreamer->SetupAudio(
				m_pPinAudio->GetMemInputPin(),
				m_pPinAudio->GetMemAllocator(),
				m_pPinAudio->GetWaveHeader());
			if (FAILED(hRslt)) {
				return hRslt;
			}

			hRslt = m_pStreamer->Commit();
			if (FAILED(hRslt)) {
				return hRslt;
			}

			hRslt = m_pStreamer->Create();
			if (FAILED(hRslt)) {
				return hRslt;
			}

			if (m_StartPos != -1) {
				m_pStreamer->RequestSeek(m_StartPos);
				m_StartPos = -1;
			}
		}

		m_pStreamer->RequestStart();

		return S_OK;
	}

	HRESULT StopStreaming()
	{
		if (m_pStreamer != 0) {
			HRESULT hRslt = m_pStreamer->Decommit();
			if (FAILED(hRslt)) {
				return hRslt;
			}

			m_pStreamer->RequestQuit();

			m_pStreamer->Uninitialize();

			delete m_pStreamer;
			m_pStreamer = 0;
		}

		return S_OK;
	}

	/* */

}; // QFilter

/* */

