/* ResidueDecoder.h */
/* 2008/11/06       */

#pragma once

#include "HuffmanDecoder.h"

/* ResidueSetup */
struct ResidueSetup {

	INT32 Type;

	INT32 Begin;
	INT32 End;
	INT32 PartSize;

	INT32 Classifications;
	INT32 ClassBook;
	INT16 (*ResidueBooks)[8];

}; /* ResidueSetup */

typedef struct ResidueSetup ResidueSetup_t;

BOOL ResidueDecoder_Setup(
	DecoderContext_t* ctx,
	BitDecoder_t*     d,
	ResidueSetup_t*   setup);

BOOL ResidueDecoder_Decode_1M(
	DecoderContext_t*       ctx,
	BitDecoder_t*           d,
	const ResidueSetup_t*   setup,
	const HuffmanDecoder_t* huff,
	FLOAT**                 z);

BOOL ResidueDecoder_Decode_2S(
	DecoderContext_t*       ctx,
	BitDecoder_t*           d,
	const ResidueSetup_t*   setup,
	const HuffmanDecoder_t* huff,
	FLOAT**                 z);

