/* OggVorbis.c */
/* 2009/07/24  */

#include "StdAfx.h"

#include "OggVorbis.h"

#include "OggVorbisReader.h"

/* */

struct QOV_Reader {

	QO_OggVorbisReader_t Reader;

	QO_StreamReader_t Stream;

	QO_MemoryPool_t Pool;

	QOV_Format_t Format;

	FILE* fp;

	IStream* p;

}; /* QOV_Reader */

/* */

QOV_Reader_t* QOV_CreateReader(void)
{
	QO_Allocator_t* allocator = Allocator_Get();

	QOV_Reader_t* t = (QOV_Reader_t*)malloc(sizeof(QOV_Reader_t));
	if (t == NULL) {
		return NULL;
	}

	memset(t, 0, sizeof(QOV_Reader_t));

	QO_MemoryPool_Init(&(t->Pool));

	t->fp = NULL;
	t->p  = NULL;

	return t;
}

void QOV_ReleaseReader(QOV_Reader_t* t)
{
	if (t != NULL) {
		QO_Allocator_t* allocator = Allocator_Get();

		QO_OggVorbisReader_Release(&(t->Reader));

		QO_MemoryPool_Release(&(t->Pool), allocator);

		if (t->fp != NULL) {
			fclose(t->fp);
		}

		if (t->p != NULL) {
			t->p->lpVtbl->Release(t->p);
		}

		free(t);
	}
}

/* */

static BOOL SetupReader(
	QOV_Reader_t* t)
{
	INT64 samples = 0;

	QO_Allocator_t* allocator = Allocator_Get();

	if (!QO_OggVorbisReader_Init(
		&(t->Reader),
		&(t->Pool),
		allocator,
		&(t->Stream))) {
		return FALSE;
	}

	if (!QO_OggVorbisReader_Setup(
		&(t->Reader))) {
		return FALSE;
	}

	if (!QO_OggVorbisReader_DetectSamples(
		&(t->Reader),
		&samples)) {
		return FALSE;
	}

	t->Format.SamplingRate = QV_GetDecoderSetupSamplingRate(t->Reader.Setup);
	t->Format.Channels     = QV_GetDecoderSetupChannels    (t->Reader.Setup);
	t->Format.Duration     = samples;

	if (!QO_OggVorbisReader_Seek(
		&(t->Reader),
		0)) {
		return FALSE;
	}

	return TRUE;
}

BOOL QOV_OpenReader(
	QOV_Reader_t* t,
	const WCHAR*  path)
{
	FILE* fp = NULL;

	_wfopen_s(&fp, path, L"rb");
	if (fp == NULL) {
		return FALSE;
	}

	QO_StreamReader_Init(&(t->Stream), fp);

	if (!SetupReader(t)) {
		fclose(fp);
		return FALSE;
	}

	t->fp = fp;

	return TRUE;
}

BOOL QOV_OpenReader_IStream(
	QOV_Reader_t* t,
	IStream*      p)
{
	QO_StreamReader_IStream(&(t->Stream), p);

	if (!SetupReader(t)) {
		return FALSE;
	}

	t->p = p;
	t->p->lpVtbl->AddRef(t->p);

	return TRUE;
}

const QOV_Format_t* QOV_GetFormat(
	QOV_Reader_t* t)
{
	return &(t->Format);
}

/* */

BOOL QOV_Seek(
	QOV_Reader_t* t,
	INT64         sample)
{
	if (!QO_OggVorbisReader_Seek(
		&(t->Reader),
		sample)) {
		return FALSE;
	}

	return TRUE;
}

BOOL QOV_Decode(
	QOV_Reader_t* t,
	VOID*         buffer,
	INT32         samples,
	INT32*        output)
{
	if (!QO_OggVorbisReader_Decode(
		&(t->Reader),
		buffer,
		samples,
		output)) {
		return FALSE;
	}

	return TRUE;
}

/* */

