var QI2Ajax_env = { 
	'count':0  // 接続インスタンスIDの種
};

// コンストラクタ
function QI2Ajax(){
	var self = this;

	self.id = ++QI2Ajax_env.count;
	QI2Ajax_env[ self.id ] = self;

	// テキストの標準化
	self.normalizeString = function(str){ return str; };

	// イベントハンドラ
	self.on_event = function(type,extra){};
	self.logger = function(str){};
	self.client_id = '';
	self.row_id= '';
	self.enable_poll = false;
	self.sendQ = [];
	self.bNotified = false;
	self.bBuby = false;
	self.mtime = new Date().getTime( );

	// サーバへ送信
	self.send = function(line){
		// log to UI
		if(self.sendlog) self.sendlog(line);
		self.sendQ.push(line);
		self.mtime = new Date().getTime( );
		if( !self.bBuby ) self.startRequest();
	};
	self.startRequest = function(){
		if( self.intervalID != null ){
			clearTimeout(self.intervalID);
			self.intervalID = null;
		}
		// create XMLHTTPRequest
		var req;
		if( window.XMLHttpRequest ){
			req = new window.XMLHttpRequest();
		}else if(window.ActiveXObject){
			try{
				req = new ActiveXObject("Msxml2.XMLHTTP");
			}catch(e){
				try{
					req = new ActiveXObject("Microsoft.XMLHTTP");
				}catch(e2){
				}
			}
		}
		if(!req){
			say("この環境ではXMLHttpRequestを使えません");
			return;
		}
		try{
			// self.logger("start request.. rowid="+self.row_id);
			req.open("POST",self.url,true);
			req.onreadystatechange = function(){
				if(req.readyState!=4) return;
				return self.parseResponse(req);
			}
			var body =[];
			body.push( "password="+encodeURIComponent(self.password) );
			body.push( "client="+encodeURIComponent(self.client_id) );
			body.push( "rowid="+encodeURIComponent(self.row_id) );
			for(var j=0,e=self.sendQ.length;j<e;++j){
				body.push( "line"+j+"="+encodeURIComponent(self.sendQ[j]));
			}
			self.sendQ=[];
			req.send( body.join('&'));
			self.bBuby = true;
		}catch(e){
			for(var i in e) say("send error: "+i+":"+e[i]);
		}
	}
	self.parseResponse = function(req ){
		// self.logger("end request..");
		if(req.status >= 300 ){
			if( self.client_id =='' ) self.stop_polling();
			say("HTTP error:"+self.url+":"+req.statusText);
			self.bBuby = false;
			return;
		}
		var list = eval("("+req.responseText+")");
		for(var i=0,e=list.length;i<e;i+=2){
			var type  = list[i];
			var extra = list[i+1];
			if( type != 'SocketData' ){
				if( type == 'ClientID'){
					self.client_id = extra;
					continue;
				}
				if( type == 'RowID'){
					self.row_id = extra;
					continue;
				}
				if( type == 'ConnectRequested') continue;
				if( type == 'DisconnectRequested') continue;
				self.logger("type="+type+" extra="+extra);
			}
			self.on_event(type,extra);
		}
		if( list.length > 0 ) self.mtime = new Date().getTime( );

		if( self.sendQ.length ){
			self.startRequest();
		}else{
			self.bBuby = false;
			var delta = (new Date().getTime( ) - self.mtime);
			if(delta> 120000) delta = 120000;
			self.intervalID = setTimeout("QI2Ajax_env["+self.id+"].poll();",delta);
		}
	};

	self.poll = function(){
		if( !self.bBuby ) self.startRequest();
	};

	//接続開始
	self.start = function(serverurl,proxy_password){
		self.url = serverurl;
		self.password = proxy_password;
		self.send("connect");
	}
	// 接続停止
	self.stop = function(){
		self.send("disconnect");
	};

	// サウンド関係
	self.addSound = function(name,url){};
	self.playSound = function(name){};

	// 後処理
	self.destruct = function(){
		self.stop_polling();
		QI2Ajax_env[ self.id ] = null;
	}

	return;
}
