package {
    import flash.events.*;
    import flash.net.Socket;
    import flash.display.Sprite;
    import flash.external.ExternalInterface;
    import flash.text.TextField;
    import flash.utils.Timer;
    import flash.text.TextFieldType;
    import flash.text.TextFieldAutoSize;
    import flash.utils.ByteArray;
    import flash.errors.EOFError;
    import flash.errors.IOError;
    import flash.system.Security;
    import flash.net.URLRequest;
    import flash.media.Sound;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.media.SoundChannel;
    import flash.utils.Timer;

    public class QI2Flash extends Sprite {
		// 接続状態
		private var conn:Socket;
		private var bConnected:Boolean = false;
		private var buf:ByteArray = new ByteArray();
		private var buf_left:int = 0;

		// 接続設定
        private var myname:String;
        private var serverhost:String;
        private var serverport:int;
        private var server_charset:String = "ISO-2022-JP-IRC";

		// JavaScript連携
		private var js_ready:Boolean       = false;
		private var js_func_say:String     = "QI2Flash_say";
		private var js_func_ready:String   = "QI2Flash_ready";
		private var js_func_event:String   = "QI2Flash_dataevent";
		private var conn_func_start:String = "conn_start";
		private var conn_func_stop:String  = "conn_stop";
		private var conn_func_send:String  = "conn_send";

		private var conn_func_addSound:String  = "addSound";
		private var conn_func_playSound:String  = "playSound";
		private var conn_func_normalizeString:String  = "normalizeString";

		// JISコンバータ
		private var jis_converter:JIS4IRC = new JIS4IRC();

		// タイマー
		private var sendTimer:Timer;

		// FlashからJSの関数に文字列を渡す場合、\ をエスケープする必要がある
		// JavaScriptから呼ばれたFlashの関数が値を返す場合もエスケープする必要がある
		private function escapeBackSlash(str:String):String{
			return str.replace(
				/[\\\%\x00-\x1f\x7f]/g
				,function():String{
					var h:String = '0'+arguments[0].charCodeAt(0).toString(16); return '%'+h.substr(h.length-2,2) 
				}
			);
		}

		// UIにログ出力
		private function say(str:String):void{
			if( js_ready ){
				// JavaScript側に送る
				ExternalInterface.call(js_func_say,myname,str);
			}else{
				// Flashのtraceを使う
				trace(str);
			}
		}

		// JavaScriptの初期化が終わったか確認する
        private function checkJavaScriptReady():Boolean{
			if( !js_ready ){
				if( ExternalInterface.call(js_func_ready,myname) ){
					js_ready = true;
					sendTimer = new Timer(500);
		            sendTimer.addEventListener(TimerEvent.TIMER, onSendTimer);
		            sendTimer.start();
		            say(escapeBackSlash("JavaScript is ready."));
		        }
			}
			return js_ready;
        }

		// JavaScriptの初期化が終わるまで定期的に呼ばれる
        private function timerHandler(event:TimerEvent):void {
			say("Checking JavaScript status...");
			if( checkJavaScriptReady() ) Timer(event.target).stop();
        }

		// コンストラクタ
		public function QI2Flash(){
			var FlashVars:Object = loaderInfo.parameters;
			jis_converter.setOption("7823c");

			for(var i:String in FlashVars ){
				// 接続オブジェクトの識別名
				if( i == "myname" ) myname = FlashVars[i];
				// JavaScript側の関数名を変更可能にする
				else if( i == "js_func_say"     ) js_func_say     = FlashVars[i];
				else if( i == "js_func_ready"   ) js_func_ready   = FlashVars[i];
				else if( i == "js_func_event"   ) js_func_event   = FlashVars[i];
				else if( i == "conn_func_start" ) conn_func_start = FlashVars[i];
				else if( i == "conn_func_stop"  ) conn_func_stop  = FlashVars[i];
				else if( i == "conn_func_send"  ) conn_func_send  = FlashVars[i];
			}

			if( ! ExternalInterface.available ){
				say("External interface is not available for this container.");
			}else{
				try{
					say("Adding callback...");
                    ExternalInterface.addCallback(conn_func_start ,conn_start);
                    ExternalInterface.addCallback(conn_func_stop ,conn_stop);
                    ExternalInterface.addCallback(conn_func_send  ,conn_send);

                    ExternalInterface.addCallback(conn_func_addSound   ,addSound);
                    ExternalInterface.addCallback(conn_func_playSound  ,playSound);
                    ExternalInterface.addCallback(conn_func_normalizeString  ,normalizeString);


                    if( ! checkJavaScriptReady() ){
                        say("JavaScript is not ready, creating timer.");
                        var readyTimer:Timer = new Timer(300,0);
                        readyTimer.addEventListener(TimerEvent.TIMER, timerHandler);
                        readyTimer.start();
                    }
                } catch (error:SecurityError) {
                    say("A SecurityError occurred: " + error.message );
                } catch (error:Error) {
                    say("An Error occurred: " + error.message);
                }
            }
        }

		private function onClose(ev:Event):void{
			ExternalInterface.call(js_func_event,myname,"Close");
            conn.removeEventListener(Event.CONNECT,onConnect);
            conn.removeEventListener(Event.CLOSE, onClose);
            conn.removeEventListener(ProgressEvent.SOCKET_DATA,onSocketData);
            conn.removeEventListener(SecurityErrorEvent.SECURITY_ERROR,onSecurityError);
            conn.removeEventListener(IOErrorEvent.IO_ERROR,onIOError);
            conn = null;
            bConnected = false;
		}
		private function onSecurityError(ev:SecurityErrorEvent ):void{
			ExternalInterface.call(js_func_event,myname,"SecurityError",ev.text);
	        conn.close();
			onClose(null);
		}
		private function onIOError(ev:IOErrorEvent ):void{
			ExternalInterface.call(js_func_event,myname,"IOError",ev.text);
	    	conn.close();
			onClose(null);
		}

		private var onSocketData_isIn:int = 0;
		private var onSocketData_count:int = 0;
		private function onSocketData(ev:ProgressEvent ):void{
			if( onSocketData_isIn ) return;
			++onSocketData_isIn;
			var recvID:int = ++onSocketData_count;
		//	say("onSocketData["+recvID+"] start. avail="+conn.bytesAvailable);
			while( conn.bytesAvailable > 0 ){
				try{
					var pre_left:int = buf_left;
					var line_count:int = 0;
					var delta:int = conn.bytesAvailable;
					if( buf.length < buf_left + delta){
						buf.length = buf_left + delta;
					}
					conn.readBytes(buf,buf_left,delta);

					// 1行ずつ文字コード変換してイベント送信
					var start:int =0;
					var end:int = buf_left + delta;
					var i:int;
					var lineno:int =0;
					for(i=0;i<end;++i){
						if( buf[i] == 0x0a ){
							buf.position = start;
							var str:String;
							if( server_charset == "ISO-2022-JP-IRC"){
								str = jis_converter.decode(buf,i-start+1);
							}else{
								str = buf.readMultiByte(i-start+1,server_charset);
							}
							str = str.replace(/[\x0d\x0a]/g,"");
					//		say("onSocketData["+recvID+"] line["+lineno+"] call start");
							ExternalInterface.call(js_func_event,myname,"SocketData",escapeBackSlash(str));
					//		say("onSocketData["+recvID+"] line["+lineno+"] call end");
							++lineno;
							start = i+1;
							++line_count;
						}
					}
					if(start >= end){
						buf_left =0;
					}else{
						var buf2:ByteArray = new ByteArray();
						buf2.length = buf.length;
						buf.position = start;
						buf.readBytes(buf2,0,end-start);
						buf=buf2;
						buf_left = end-start;
					}
					say("onSocketData pre_left="+pre_left+" delta="+delta+" lines="+line_count+" left="+buf_left);
				}catch(e:Error){
					say("onSocketData:"+e.message);
				}
			}
		//	say("onSocketData["+recvID+"] end.");
			--onSocketData_isIn;
		}

		private var sendQ:Array = [];
		private var pre_time:Number;
		private var penalty_time:Number;

		private function onSendTimer(evt:TimerEvent):void{
			if(!bConnected) return;
			var now:Number  = (new Date()).time;
			var diff:Number = (now-pre_time);
			if(diff<0.5) return;
			pre_time=now;
			if( (penalty_time -= diff) < 0) penalty_time=0;
			while( sendQ.length >0 ){
				if( penalty_time >= 5000 ) break;
				penalty_time += sendQ[0][0];
				try{
					conn.writeBytes(sendQ[0][1]);
				}catch(e:IOError){
					say("conn.writeBytes:"+e.message);
				}
				sendQ.shift();
			}
			try{
				conn.flush();
			}catch(e:IOError){
				say("conn.flush:"+e.message);
			}
		}

		// 送信キューにデータを追加する
		// JacaScriptから呼ばれる
		public function conn_send(line:String):String{
			if(!bConnected) return "not connected.";
			var bytes:ByteArray;
			if( server_charset == "ISO-2022-JP-IRC"){
				bytes = jis_converter.encode(line+"\r\n");
			}else{
				bytes = new ByteArray();
				bytes.writeMultiByte(line+"\r\n",server_charset);
			}
			bytes.position = 0;
			var penalty:Number = 1000 + (bytes.length*1000/45);
			sendQ.push( [ penalty,bytes] );
			onSendTimer(null);
			return "";
		}

		// 接続終了
		// JacaScriptから呼ばれる
		public function conn_stop():String{
			if(conn==null) return "not connected.";
			try{ conn.close(); }catch(e:Error){ say("conn_stop:"+e.message); }
			onClose(null);
			return "";
		}

		// 接続開始
		// JacaScriptから呼ばれる
		public function conn_start(
			a_server_charset:String,
			a_myname:String,
			a_serverhost:String,
			a_serverport:int,
			a_polycyfile:String
		):String{
			if(conn!=null) return "already connected.";
			bConnected = false;
			server_charset = a_server_charset;
			myname = a_myname;
			serverhost = a_serverhost;
			serverport = a_serverport;
			try{
				conn = new Socket();
	            conn.addEventListener(Event.CONNECT,onConnect);
	            conn.addEventListener(Event.CLOSE, onClose);
	            conn.addEventListener(ProgressEvent.SOCKET_DATA,onSocketData);
	            conn.addEventListener(SecurityErrorEvent.SECURITY_ERROR,onSecurityError);
	            conn.addEventListener(IOErrorEvent.IO_ERROR,onIOError);
	            if(a_polycyfile){
					try{
						Security.loadPolicyFile(a_polycyfile);
						say("OK load policy file "+a_polycyfile);
					}catch(e:Error){
						say("NG cannot load policy file. "+e.message + " "+a_polycyfile)
					}
				}
	            say("Connecting to "+serverhost+"#"+serverport);
	            conn.connect(serverhost,serverport);
	        }catch(e:Error){
				return e.message;
			}
			return "";
		}
		private function onConnect(ev:Event):void{
			bConnected = true;
			sendQ = [];
			pre_time = (new Date()).time;
			penalty_time =0;

			say("Connected.");
			ExternalInterface.call(js_func_event,myname,"Connect");
		}
		
		/////////////////////////////////////////////////////
		// 文字コード変換を行って化ける文字がでるか確認する
		public function normalizeString(str:String):String{
			if(str==null) return "(null)";
			var tmp:ByteArray;
			var result:String = str;
			// 指定の文字セットにエンコード
			if( server_charset == "ISO-2022-JP-IRC"){
				tmp = jis_converter.encode(str);
			}else{
				tmp = new ByteArray();
				tmp.writeMultiByte(str,server_charset);
			}
			// Unicodeにデコード
			tmp.position =0;
			if( server_charset == "ISO-2022-JP-IRC"){
				result = jis_converter.decode(tmp,tmp.length);
			}else{
				result = tmp.readMultiByte(length,server_charset);
			}
			return escapeBackSlash(result);
		}

		/////////////////////////////////////////////////////
		// 効果音を鳴らす

		private var sound_map:Object = {};
		public function addSound(name:String,url:String):void{
			if( sound_map[name] ) return;
			try{
				var s:Sound = new Sound();
				s.load(new URLRequest(url));
				sound_map[name]=s;

				var transform:SoundTransform = SoundMixer.soundTransform;
				if(! SoundMixer.areSoundsInaccessible() ){
					say("SoundMixer.areSoundsInaccessible returns false");
				}else{
					SoundMixer.soundTransform.volume = 0.3;
				}
			}catch(e:Error){
				say("addSound: "+e.message);
			}
		}
		private var now_playing:SoundChannel = null;
		public function playSound(name:String):void{
			var s:Sound = sound_map[name];
			if(s==null) return;
			try{
				say("playSound: bytes="+s.bytesLoaded+"/"+s.bytesTotal+" isBuffering="+s.isBuffering+" length ="+s.length+" url="+s.url);
				if( now_playing ) now_playing.stop();
				now_playing = s.play(0,0);
			}catch(e:Error){
				say("playSound: "+e);
				say("playSound: "+e.message);
			}
		}
    }
}

////////////////////////////////////////////////////////////////////////

// IRC用JISコンバーター
import flash.utils.ByteArray;
class JIS4IRC{
	// 各種変換テーブル

	[Embed(source='x201u2z.map', mimeType='application/octet-stream')]
	private static const map201z_class:Class;
	private var map201z:ByteArray;

	[Embed(source='x208decode.map', mimeType='application/octet-stream')]
	private static const map208decode_class:Class;
	[Embed(source='x212decode.map', mimeType='application/octet-stream')]
	private static const map212decode_class:Class;
	private var map208decode:ByteArray;
	private var map212decode:ByteArray;
	private var map2132decode:ByteArray;

	[Embed(source='x208encode.map', mimeType='application/octet-stream')]
	private static const map208encode_class:Class;
	[Embed(source='x212encode.map', mimeType='application/octet-stream')]
	private static const map212encode_class:Class;
	private var map208encode:ByteArray;
	private var map212encode:ByteArray;

	//
	private function scanTable(table:ByteArray,b1:uint,b2:uint):uint{
		if(table!=null){
			// 上位8ビットのマップを読む
			table.position = b1*2;
			var pos:int = table.readUnsignedShort();
			if(pos != 0xFFFF){
				// 下位8ビットのマップを確認
				table.position=0;
				var size:uint = table[pos++]+1;
				if( b2 >= table[pos] && b2 <= table[pos+size*3-3] ){
					// bsearchする
					while(size>0){
						var mid:uint = size>>1;
						var diff:int = b2-table[pos+mid*3];
						if(!diff) return (table[pos+mid*3+1]<<8)+table[pos+mid*3+2];
						if(diff>0){
							pos += (mid+1)*3;
							size-=  mid+1;
						}else{
							size=mid;
						}
					}
				}
			}
		}
		return 0;
	}
	private function scanDecodeTable(b1:uint,b2:uint,table:ByteArray,mode:String):String{
		var unicode:uint = scanTable(table,b1,b2);
		if(unicode==0){
			return "("+mode+":"+b1.toString(16)+","+b2.toString(16)+")";
		}
		return String.fromCharCode(unicode);
	}

	private function scanEncodeTable(table:ByteArray,unicode:uint):uint{
		var b1:uint = (unicode>>8)&255;
		var b2:uint = (unicode   )&255;
		var kuten:uint = scanTable(table,b1,b2);
		return kuten;
	}

	// 半角カナのデコード
	private function decodeX201(code:uint,mode:String,shiftmode:int):String{
		code |= 0x80;
		if(code >= 0xa1 && code <= 0xdf ) return String.fromCharCode( code+(0xFF61-0xa1) );
		return "(X201:x"+code.toString(16)+";)";
	}

	private function str2byte(ba:ByteArray,str:String):void{
		for(var i:int=0;i<str.length;++i){
			ba.writeByte(str.charCodeAt(i));
		}
	}

	// JIS X 0201 カタカナの扱い
	private var optX201:int; 
		// 0 z○ 全角カナに変換
		// 1 7○ Kana  7bit "ESC ( I"
		// 2 j○ Roman 8bit "ESC ( J"
		// 3 k○ Roman 7bit "ESC ( J SO/SI"  未対応
	
	// 機種依存文字の扱い
	private var optUseX208extra:Boolean; // 8□ JIS X 0208を120区まで拡張
	private var optUseX212:Boolean;      // 2□ JIS X 0212の使用
	private var optUseX213:Boolean;      // 3□ JIS X 0213の使用

	// エスケープを伴わない非ASCII文字の文字コード
	private var optDefaultEncoding:String;

	// 変換オプションの設定
	public function setOption(str:String):void {
		// デフォルトにリセット
		optX201 = 0;
		optUseX208extra = false;
		optUseX212 = false;
		optUseX213 = false;
		optDefaultEncoding = "ms_Kanji";
	
		for(var i:int = 0;i<str.length;++i){
			var c:String = str.charAt(i);
			switch(c){
			case 'z': optX201 =0; break;
			case '7': optX201 =1; break;
			case 'j': optX201 =2; break;
			case 'k': optX201 =3; break;

			case '8': optUseX208extra =true; break;
			case '2': optUseX212 =true; break;
			case '3': optUseX213 =true; break;

			case 'c': optDefaultEncoding ="ms_Kanji"; break;
			case 'u': optDefaultEncoding ="utf-8"; break;
			case 'a': optDefaultEncoding ="iso-8859-1"; break;
			default:
				trace("JIS4IRC: unknown option character ",c);
			}
		}
	}

	// エンコード時の文字変換
	private var encode_conv_map:Object = {
		'〜':'～',
		'−':'-',
		'∑':'∑',
		'︰':'：',
		'‾':'~'
	};

	// ISO-2022-JP のエスケープシーケンス
	private var esc_map:Object = {};
	private function addEscapeMap( mode:int,str:String):void{
		var ba:ByteArray = new ByteArray();
		str2byte(ba,str);
		esc_map[mode]=ba;
	}

	// コンストラクタ
    public function JIS4IRC(){
		// 埋め込みデータのインスタンスを作成
		map208decode = new map208decode_class();
		map208encode = new map208encode_class();
		map212decode = new map212decode_class();
		map212encode = new map212encode_class();
		map201z      = new map201z_class();

		// esc_mapにエスケープシーケンスを設定
		addEscapeMap( 0,"\x1b(B");
		addEscapeMap( 208  ,"\x1b$\x42");
		addEscapeMap( 212  ,"\x1b$(\x44");
		addEscapeMap( 2131 ,"\x1b$(Q");
		addEscapeMap( 2132 ,"\x1b$(P");
		addEscapeMap( 72010,"\x1b(I");
		addEscapeMap( 82010,"\x1b(J");
	};

	public function decode(ba:ByteArray,length:int):String{
		var result:String = new String();
		var start:int;
		var b:uint;
		if(length ==0) length = ba.bytesAvailable;
		Loop: while(length > 0 ){
			// 非エスケープ状態の部分を読む
			{
				start = ba.position;
				var n:int =0;

				// ESCの直前までをまとめて処理する
				var cnt:int=0;
				while( length > 0 ){
					b = ba.readUnsignedByte();
					--length;
					++cnt;
					if( b == 0x1b ) break;
					++n;
				}
				ba.position = start;
				length += cnt;
				if(n>0){
					for(var i:int=0;i<n;++i){
						result += String.fromCharCode( ba.readUnsignedByte() );
						--length;
					}
				}
				if( length <= 0 ) break;
			}
			start = ba.position;
			var mode:uint = 0;
			// エスケープ部分を読む
			while( length > 0 ){
				b = ba.readUnsignedByte(); --length;
				// 空白なら必ずASCIIに戻す
				if(b==0x20) continue Loop;
				// SHIFT OUT
				if(b==0x0e){
					if(mode == 72010){ mode=72011; continue; }
					if(mode == 82010){ mode=82011; continue; }
					continue Loop;
				}
				// SHIFT IN
				if(b==0x0F){
					if(mode===72011){ mode=72010; continue ; }
					if(mode===82011){ mode=82010; continue ; }
					continue  Loop;
				}
				// ESCAPE
				if(b==0x1b){ // ESC
					var elen:int = 1; // エスケープタグの長さ
					if( length >= 2 ){
						elen = 3;
						var c1:uint = ba.readUnsignedByte();
						var c2:uint = ba.readUnsignedByte();
						length -= 2;
						if(c1 == 0x28 /* ( */ ){
							if(c2 == 0x42 /* B */ ){mode=    0;continue Loop;}	// ASCII ESC (B アスキー
							if(c2 == 0x49 /* I */ ){mode=72010;continue     ;}	// JIS X 0201 片仮名 7ビット半角カナの開始
							if(c2 == 0x4a /* J */ ){mode=82010;continue     ;}	// JIS X0201(LH) ESC (J 半角カナ
						}else if(c1 == 0x24 /* $ */ ){
							if(c2 == 0x40 /* @ */){mode=2131; continue;} // ESC $@ JIS X 0213の1面(include JIS X0208('78)) 
							if(c2 == 0x42 /* B */){mode= 208; continue;} // JIS X0208('83) 
							if(c2 == 0x49 /* I */){mode= 201; continue;} // 8ビット半角カナの開始
							if(c2 == 0x28 /* ( */ && length >= 1 ){
								elen = 4;
								var c3:uint = ba.readUnsignedByte();
								--length;
								if(c3 == 0x4f /* O */){mode=2131; continue;} // JIS X 0213の1面(include JIS X0212?)
								if(c3 == 0x50 /* P */){mode=2132; continue;} // JIS X 0213の2面
								if(c3 == 0x44 /* D */){mode=212;  continue;} // JIS X 0212 補助漢字
							}
						}
					}
					ba.position -= elen;
					var warnStr:String = "";
					for(var j:int = 0;j<elen;++j){
						b = ba.readUnsignedByte();
						warnStr += " "+ ("00"+b.toString(16)).substr(-2,2);
					}
					result += "(JIS4IRC: unsupported escape sequence"+warnStr+")";
					continue  Loop;
				}
				var b2:uint;
				switch(mode){
				case 0: continue Loop;

				case 201  : result += (decodeX201(b,' ',0)); break;
				case 82010: result += (decodeX201(b,'J',0)); break;
				case 82011: result += (decodeX201(b,'J',1)); break;
				case 72010: result += (decodeX201(b,'I',0)); break;
				case 72011: result += (decodeX201(b,'I',1)); break;

				case 208:
					if(length <= 0 ) continue Loop;
					b2 = ba.readUnsignedByte(); --length;
					result += scanDecodeTable(b,b2,map208decode,"x208");
					break;
				case 212:
					if(length <= 0 ) continue Loop;
					b2 = ba.readUnsignedByte(); --length;
					result += scanDecodeTable(b,b2,map212decode,"x212");
					break;
				case 2131:
					if(length <= 0 ) continue Loop;
					b2 = ba.readUnsignedByte(); --length;
					result += scanDecodeTable(b,b2,map208decode,"x2131");
					break;
				case 2132:
					if(length <= 0 ) continue Loop;
					b2 = ba.readUnsignedByte(); --length;
					result += scanDecodeTable(b,b2,map2132decode,"x2132");
					break;
				default:
					continue Loop;
				}
			}
		}
		return result;
	}


	public function encode(src:String):ByteArray{
		var ba:ByteArray = new ByteArray();
		
		var src_len:int = src.length;
		var mode:int = 0;
		var newmode:int;
		var b1:uint;
		var b2:uint;

		for(var i:int =0;i<src_len;++i){
			var unichar:String = src.charAt(i);
			var tmp:String = encode_conv_map[unichar];
			if( tmp !=null) unichar = tmp;
			var unicode:uint = unichar.charCodeAt(0);

			if( unicode <=0x7f ){
				// ASCIIまたは制御コード
				newmode = 0;
				b1 = unicode;
				b2 = 0;
			}else if( unicode >= 0xFF61 && unicode <= 0xFF9f ){
				// 半角カナ
				unicode -= 0xFF61;
				if( optX201 == 0 ){
					// 全角カナに変換する
					map201z.position = unicode;
					newmode = 208;
					b1 = 0x30;
					b2 = map201z.readUnsignedByte();
				}else{
					b1 = unicode + 0xa1;
					b2 = 0;
					switch(optX201){
					default:
					case 1: newmode=72010; b1 &= 0x7f;break;
					case 2: newmode=82010; break;
					}
				}
			}else{
				do{
					// X208に文字があるか確認する
					var kuten:uint = scanEncodeTable(map208encode,unicode);
					if( kuten >0 ){
						newmode = 208;
						b1 = kuten>>8;
						b2 = kuten&0xff;
						if( optUseX208extra || (b1 <= 126 && b2 <= 126 ) ) break;
					}
				/* 未対応
					if( optUseX213 ){
						kuten = scanEncodeTable(map213encode,unicode);
						if( kuten > 0xFFFF ){
							newmode = 2132;
							b1 = (kuten>>8)&0xff;
							b2 = (kuten   )&0xff;
							break;
						}else if(kuten>0){
							newmode = 2131;
							b1 = (kuten>>8)&0xff;
							b2 = (kuten   )&0xff;
							break;
						}
					}
				*/
					if( optUseX212 ){
						kuten = scanEncodeTable(map212encode,unicode);
						if( kuten >0 ){
							newmode = 212;
							b1 = kuten>>8;
							b2 = kuten&0xff;
							break;
						}
					}
					// 変換できない
					newmode = -1;
				}while(false);
			}
			/////////////
			if( newmode==-1 ){
				if(mode != 0 ){
					mode=0;
					ba.writeBytes(esc_map[mode]);
				}
				str2byte(ba,"&#x"+unicode.toString(16)+";");
			}else{
				if(mode != newmode){
					mode=newmode;
					ba.writeBytes(esc_map[mode]);
				}
				ba.writeByte(b1);
				if(b2!=0) ba.writeByte(b2);
			}
		}
		newmode=0;
		if(mode != newmode) ba.writeBytes(esc_map[mode=newmode]);
		ba.position = 0;
		return ba;
	}

	// references：
	// http://www.asahi-net.or.jp/~wq6k-yn/code/enc-x0213.html
	// http://www2d.biglobe.ne.jp/~msyk/charcode/jisx0201kana/
	// http://www.m17n.org/m17n2000_all_but_registration/proceedings/kawabata/jisx0213.html
	// http://www.ingrid.org/java/i18n/unicode.html
}

