#pragma once

#include <C2/gl/GlslShader.h>
#include <C2/gl/GlewFramebuffer.h>
#include <C2/gl/GlTextureObject.h>

#include "ShaderInterface.h"



class EnvMap : public ShaderInterface
{
public:
	EnvMap(ShaderContext* context);

	const char* GetShaderName(void)
	{
		return "EnvMap";
	}

	bool InitializeShader(const std::string& shader_libdir);

	virtual void BeginShader(void);
	virtual void EndShader(void);

	virtual void SetColorTextureEnabled(bool enabled);
	virtual void SetDublesideEnabled(bool enabled);
	virtual void SetLightingEnabled(bool enabled);


private:
	lib_gl::GlslProgram m_Shader;
};
