#pragma once



class GuiBinder
{
public:
	virtual void UpdateGUI(bool silent) = 0;
	virtual void UpdateData(void) = 0;
};


class MenuBinder : public GuiBinder
{
public:
	MenuBinder(QAction* _menu, bool* _value) :
		menu(_menu),
		value(_value)
	{
	}

	virtual void UpdateGUI(bool silent)
	{
		if (silent)
			menu->blockSignals(true);

		menu->setChecked(*value);

		if (silent)
			menu->blockSignals(false);
	}

	virtual void UpdateData(void)
	{
		(*value) = menu->isChecked();
	}

	QAction* GetMenu(void) { return menu; }
	const QAction* GetMenu(void) const { return menu; }

private:
	QAction* menu;
	bool* value;
};


class CheckboxBinder : public GuiBinder
{
public:
	CheckboxBinder(QCheckBox* _check, bool* _value) :
		check(_check),
		value(_value)
	{
	}

	virtual void UpdateGUI(bool silent)
	{
		if (silent)
			check->blockSignals(true);

		check->setChecked(*value);

		if (silent)
			check->blockSignals(false);
	}

	virtual void UpdateData(void)
	{
		(*value) = check->isChecked();
	}

	QCheckBox* GetCheckBox(void) { return check; }
	const QCheckBox* GetCheckBox(void) const { return check; }

private:
	QCheckBox* check;
	bool* value;
};


class DataBinderMap
{
public:
	void AddBinder(GuiBinder* binder)
	{
		m_BinderMap.push_back(binder);
	}

	void Clear(void)
	{
		m_BinderMap.clear();
	}

	void UpdateAllGUI(bool silent)
	{
		for (GuiBinder& binder : m_BinderMap)
		{
			binder.UpdateGUI(silent);
		}
	}

	void UpdateAllData(void)
	{
		for (GuiBinder& binder : m_BinderMap)
		{
			binder.UpdateData();
		}
	}

public:
	boost::ptr_vector<GuiBinder> m_BinderMap;
};
