#pragma once

#include "SeqTrans.h"



namespace geom
{


class Bone;


class SceneNode
{
public:
	SceneNode(void)
	{
		m_Bone = NULL;
		m_Parent = NULL;
	}

	lm::matrix4f GetFrameTransform(int frame) const;

	int GetKeyframeMax(void) const;

public:
	std::string m_Name;
	SceneNode* m_Parent;
	boost::ptr_vector<SceneNode> m_Children;

	lm::matrix4f m_Transform;
	lm::matrix4f m_WorldTrans;

	SeqTrans m_SeqTrans;

	Bone* m_Bone;
	std::vector<int> m_MeshIDs;
};


}
