#include "StdAfx.h"
#include "Cursor3D.h"

#include <LibQtGeoViewerCore/GeomObject.h>



Cursor3D::Cursor3D(void)
{
	ShowCursor     .Reset( false , "ShowCursor"     );
	CursorDepth    .Reset( false , "CursorDepth"    );
	ShowMeasure    .Reset( false , "ShowMeasure"    );
	ShowMeasureLen .Reset( false , "ShowMeasureLen" );
	ShowMeasureXYZ .Reset( false , "ShowMeasureXYZ" );
	ShowAxis       .Reset( false , "ShowAxis"       );
	ShowCoord      .Reset( false , "ShowCoord"      );
	CheckBaryCoord .Reset( false , "CheckBaryCoord" );
	SelCloseMat    .Reset( false , "SelCloseMat"    );
	RecordStroke   .Reset( false , "RecordStroke"   );
	ShowStrokeLen  .Reset( false , "ShowStrokeLen"  );
	TranspStorke   .Reset( false , "TranspStorke"   );

	SphereClip = SphereClipType::None;
	HoleRangeRatio = 0.25f;

	CloseFaceMBuf = NULL;

	CutplaneRot.identity();
}

void Cursor3D::ResetCursorPos(void)
{
	CursorPos.set(0.0f, 0.0f, 0.0f);
	CutplaneRot.identity();
}

void Cursor3D::ResetMeasure(void)
{
	MeasurePos = CursorPos;
}

void Cursor3D::ResetCloseFace(void)
{
	CloseFaceMBuf = NULL;
	CloseFace.Reset();
}

lm::vec3f Cursor3D::GetMidMeasurePos(void) const
{
	return (CursorPos + MeasurePos) * 0.5f;
}

float Cursor3D::GetMeasureLength(void) const
{
	return (CursorPos - MeasurePos).length();
}

bool Cursor3D::IsHoleActive(void) const
{
	if (!ShowCursor)
		return false;

	return SphereClip == SphereClipType::Hole;
}

bool Cursor3D::IsHoleRevActive(void) const
{
	if (!ShowCursor)
		return false;

	return SphereClip == SphereClipType::ShowAround;
}

bool Cursor3D::IsCircleClipActive(void) const
{
	if (!ShowCursor)
		return false;

	return SphereClip != SphereClipType::None;
}

void Cursor3D::PushStroke(void)
{
	if (Strokes.empty())
		Strokes.push_back(CursorStroke());

	CursorStroke& s = Strokes.back();

	s.AddPoint(CursorPos);
}

void Cursor3D::CutStroke(void)
{
	if (Strokes.empty())
		return;

	CursorStroke& s = Strokes.back();
	if (s.IsEmpty())
		return;

	Strokes.push_back(CursorStroke());
}

void Cursor3D::ClearStroke(void)
{
	Strokes.clear();
}

float Cursor3D::GetSphereClipLen(const lm::range3f& bbox) const
{
	return bbox.max_length() * HoleRangeRatio;
}

void Cursor3D::GetFreeCutParam(lm::vec3f& p, lm::vec3f& n)
{
	p = CursorPos;
	n = -CutplaneRot.get_ey();
}
