#pragma once

#include <C2/lm/vmatrix.h>

#include <C2/gl/GlTextureObject.h>
#include <C2/gl/GlewFrameBuffer.h>

#include <C2/graph/Color.h>


class BackBuffer
{
public:
	void InitializeBuffer(int width, int height);
	void ReleaseBuffer(void);

	void BeginFBO(void);
	void EndFBO(void);

	void GetPixels(lm::matrix<lgr::color3f>& buf);

private:
	void CreateTextureRGB(lib_gl::GlTextureObject& tex, GLint internalformat, int width, int height);

public:
	int m_Width;
	int m_Height;
	lib_gl::GlFramebuffer   m_FBO;
	lib_gl::GlTextureObject m_TexColor;
	lib_gl::GlTextureObject m_TexDepth;
	lib_gl::GlRenderbuffer  m_RenderBuffer;
};
