#pragma once

#ifdef _WIN32

#include <sstream>
#include <vector>
#include <string>
#include <exception>

#include <Windows.h>


namespace util
{


class Directory
{
public:
	static std::vector<std::string> GetFiles(const std::string& dir_path);
	static std::vector<std::string> GetFiles(const std::string& dir_path, const std::string& filter);
};


//! wtH_̃t@C擾
//! ex: std::vector<std::string> path = util::Directory::GetFiles("C:\\aa\\");
inline
std::vector<std::string> Directory::GetFiles(const std::string& dir_path)
{
	return GetFiles(dir_path, "*.*");
}

//! wtH_̃t@C擾
//! ex: std::vector<std::string> path = util::Directory::GetFiles("C:\\aa\\", "*.png");
inline
std::vector<std::string> Directory::GetFiles(const std::string& dir_path, const std::string& filter)
{
	WIN32_FIND_DATAA fd;

	std::string ss = dir_path + filter;
	HANDLE hFind = FindFirstFileA(ss.c_str(), &fd);

	// s
	if (hFind == INVALID_HANDLE_VALUE)
	{
		throw std::exception("util::Directory::GetFiles failed");
	}

	std::vector<std::string> fileList;
	do
	{
		// tH_͏
		if (fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			continue;
		// Bt@C͏
		if (fd.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN)
			continue;

		fileList.push_back(fd.cFileName);
	} while(FindNextFileA(hFind, &fd));

	FindClose(hFind);

	return fileList;
}

}


#endif
