﻿#pragma once

#include "Color.h"
#include "RawImage.h"


namespace lgr
{


//! RawImage用画像生成クラス.
class ImageGenerator
{
public:
	template<typename T>
	static void GenCheck( RawImage<T>& o_image , int unit_size , int unit_repeat , const T& col_a , const T& col_b );

	template<typename T>
	static void GenStripeX( RawImage<T>& o_image , int unit_size , int unit_repeat , const T& col_a , const T& col_b );
	template<typename T>
	static void GenStripeY( RawImage<T>& o_image , int unit_size , int unit_repeat , const T& col_a , const T& col_b );
};



// ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//! チェック模様を生成する.
template<typename T> inline
void ImageGenerator::GenCheck( RawImage<T>& o_image , int unit_size , int unit_repeat , const T& col_a , const T& col_b )
{
	int axis_size = unit_size * unit_repeat * 2;
	o_image.resize( axis_size , axis_size );

	for( int i = 0 ; i < axis_size ; ++i )
	{
		bool parity_i = ( ( i / unit_size ) % 2 == 0 );
		for( int j = 0 ; j < axis_size ; ++j )
		{
			bool parity_j = ( ( j / unit_size ) % 2 == 0 );
			
			bool bUseA = true;
			if( parity_i ) bUseA = !bUseA;
			if( parity_j ) bUseA = !bUseA;

			o_image.at( i , j ) = ( bUseA ? col_a : col_b );
		}
	}
}


//! X方向に縞が発生するようにストライプを生成する.
template<typename T> inline
void ImageGenerator::GenStripeX( RawImage<T>& o_image , int unit_size , int unit_repeat , const T& col_a , const T& col_b )
{
	int axis_size = unit_size * unit_repeat * 2;
	o_image.resize( axis_size , axis_size );

	for( int i = 0 ; i < axis_size ; ++i )
	{
		bool parity_i = ( ( i / unit_size ) % 2 == 0 );
		for( int j = 0 ; j < axis_size ; ++j )
		{
			o_image.at( i , j ) = ( parity_i ? col_a : col_b );
		}
	}
}

//! Y方向に縞が発生するようにストライプを生成する.
template<typename T> inline
void ImageGenerator::GenStripeY( RawImage<T>& o_image , int unit_size , int unit_repeat , const T& col_a , const T& col_b )
{
	int axis_size = unit_size * unit_repeat * 2;
	o_image.resize( axis_size , axis_size );

	for( int j = 0 ; j < axis_size ; ++j )
	{
		bool parity_j = ( ( j / unit_size ) % 2 == 0 );
		for( int i = 0 ; i < axis_size ; ++i )
		{
			o_image.at( i , j ) = ( parity_j ? col_a : col_b );
		}
	}
}


}
