#include "StdAfx.h"
#include "OptionRender.h"

#include <C2/gl/OpenGLUT/OpenGlutStringExt.h>



void OptionRender::DrawAngleCross(gl::Camera& camera)
{
	glPushAttrib(GL_ENABLE_BIT|GL_LINE_BIT|GL_POINT_BIT);
	glLineWidth(1.0f);
	glPointSize(7.0f);
	glDisable(GL_LIGHTING);

	const lm::vec3f& c = camera.m_Manip.m_EyePos;
	lm::vec3f f = camera.m_Manip.GetFront();

	float nn = asin(f.y);

	f.y = 0.0f;
	float fl = f.length();
	if(fl <= 0.0f)
		f.set(1.0f, 0.0f, 0.0f);
	else
		f /= fl;

	lm::vec3f b = lm::cross(f, lm::vec3f(0.0f, 1.0f, 0.0f)).get_normalize();

	for(size_t s = 0; s < 3; ++s)
	{
		if(s == 0)
			glBegin(GL_LINE_LOOP);
		else if(s == 1)
			glBegin(GL_POINTS);

		glColor3d(1,0,0);
		for(size_t i = 0; i < 72; ++i)
		{
			float n = (int)i / 72.0f;
			float r = M_PI*2.0f * n;

			lm::vec3f d1 = f;
			d1.rotate(r, b);
			d1 += c;

			glVertex3fv( d1.v() );

			if(s == 2)
			{
				int hr = i * 5;
				if(hr > 180) hr = hr - 360;
				glutBitmapStringVal3f(d1, hr);
			}
		}

		if(s != 2)
			glEnd();

		if(s == 0)
			glBegin(GL_LINE_LOOP);
		else if(s == 1)
			glBegin(GL_POINTS);

		glColor3d(0,0,1);
		for(size_t i = 0; i < 72; ++i)
		{
			float n = (int)i / 72.0f;
			float r = M_PI*2.0f * n;

			lm::vec3f d2(1.0f, 0.0f, 0.0f);
			d2.rotate_y(r);
			d2.rotate(nn, b);

			d2 += c;
			glVertex3fv( d2.v() );

			if(s == 2)
				glutBitmapStringVal3f(d2, i * 5);
		}

		if(s != 2)
			glEnd();
	}

	glPopAttrib();
}
