#pragma once



class GLProjection
{
public:
	void Initialize(void)
	{
		glGetIntegerv(GL_VIEWPORT, view);
		glGetDoublev(GL_MODELVIEW_MATRIX, model);
		glGetDoublev(GL_PROJECTION_MATRIX, proj);
	}

	const GLint* GetViewport(void) const { return view; }

	void Project(const lm::vec3f& cp, GLdouble& wx, GLdouble& wy, GLdouble& wz)
	{
		gluProject(cp.x, cp.y, cp.z, model, proj, view, &wx, &wy, &wz);
	}

	float GetPosDepth(const lm::vec3f& cp)
	{
		GLdouble wx, wy, wz;
		Project(cp, wx, wy, wz);
		return (float)wz;
	}

	void Unproject(const GLdouble& wx, const GLdouble& wy, const GLdouble& wz, lm::vec3f& dst)
	{
		GLdouble mx, my, mz;
		gluUnProject(wx, wy, wz, model, proj, view, &mx, &my, &mz);
		dst.set(mx, my, mz);
	}

private:
	GLint view[4];
	GLdouble model[16];
	GLdouble proj[16];
};
