#include "StdAfx.h"
#include "TextureLib.h"


namespace geom
{


void TextureLib::Clear(void)
{
	for (gl::GlTexture& t : Textures)
	{
		t.FinalizeTexture();
	}
	Textures.clear();
}

gl::GlTexture* TextureLib::FindTexture(const std::string& filepath)
{
	for (gl::GlTexture& tex : Textures)
	{
		const std::string& p = tex.GetSourceFilePath();
		if (p == filepath)
			return &tex;
	}

	return NULL;
}

gl::GlTexture* TextureLib::LoadFromFile(const std::string& filepath)
{
	gl::GlTexture* ctex = new gl::GlTexture;
	Textures.push_back(ctex);

	if (!ctex->LoadTextureFromFile(filepath.c_str(), false))
	{
		Textures.pop_back();
		return NULL;
	}

	return ctex;
}


}
