using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using Microsoft.Win32;


namespace ChangeExtDefaultApp
{
	class DefaultAppConfig
	{
		//֘Atgq
		public string extension;

		//sR}hC
		public string commandline;

		//t@C^Cv
		public string fileType;

		//iut@C̎ށvƂĕ\j(optional)
		public string description;

		//
		public string verb;

		//̐iGNXv[̃ReLXgj[ɕ\j(optional)
		public string verb_description;

		//ACR̃pXƃCfbNX
		public string iconPath;
		public int iconIndex = 0;
	}

	class ExtDefaultApp
	{
		public void Execute(DefaultAppConfig config)
		{
			//t@C^Cvo^
			RegisterFileType(config.fileType, config.extension);

			RegistryKey subkey_root = Registry.ClassesRoot.CreateSubKey(config.fileType);
			RegistryKey subkey_shell = subkey_root.CreateSubKey("shell\\" + config.verb);
			RegistryKey subkey_cmd = subkey_shell.CreateSubKey("command");

			//t@C^CvƂ̐o^
			if(config.description != "")
				subkey_root.SetValue("", config.description);

			//Ƃ̐o^
			if(config.verb_description != "")
				subkey_shell.SetValue("", config.verb_description);

			//R}hCo^
			subkey_cmd.SetValue("", config.commandline);

			subkey_cmd.Close();

			//ACR̓o^
			RegistryKey subkey_icon = Registry.ClassesRoot.CreateSubKey(config.fileType + "\\DefaultIcon");
			subkey_icon.SetValue("", config.iconPath + "," + config.iconIndex.ToString());

			subkey_icon.Close();
		}

		private void RegisterFileType(string fileType, string extension)
		{
			RegistryKey regkey = Registry.ClassesRoot.CreateSubKey(extension);
			regkey.SetValue("", fileType);
			regkey.Close();
		}
	}
}
