#pragma once

#include <iostream>
#include <fstream>
#include <vector>



namespace util
{


//! Xg[̃TCY擾.
//! Xg[JɎsȂ΂ȂȂ.
inline size_t GetStreamSize( std::istream& stream )
{
	stream.seekg( 0 , std::ios::end );
	std::fstream::pos_type pos_end = stream.tellg();

	stream.seekg( 0 , std::ios::beg );
	std::fstream::pos_type pos_beg = stream.tellg();

	size_t stream_size = pos_end - pos_beg;
	return stream_size;
}


//! Xg[̓eɓǂݍ
inline void LoadBufferFromStream(std::vector<char>& o_buffer, std::istream& stream)
{
	size_t filesize = GetStreamSize(stream);
	o_buffer.resize( filesize );
	stream.read( &o_buffer[0] , filesize );
}

//! t@C̓eɓǂݍ
inline bool LoadBufferFromFile(std::vector<char>& o_buffer, const char* filename)
{
	std::ifstream ifs( filename , std::ios::binary );
	if( !ifs.is_open() )
		return false;

	LoadBufferFromStream( o_buffer , ifs );
	return true;
}

inline bool IsLineEnd(char in)
{
	switch (in)
	{
	case '\r' :
	case '\n' :
	case '\0' :
	case '\f' :
		return true;
	default:
		return false;
	}
}

inline bool IsWS(char in)
{
	switch (in)
	{
	case ' ' :
	case '\t' :
		return true;
	default:
		return false;
	}
}

inline bool SkipSpaces(const char** inout)
{
	while(IsWS(**inout))
	{
		++*inout;
	}
	*inout = *inout;
	return !IsLineEnd(**inout);
}


}
