﻿#pragma once

#include <windows.h>


namespace lgr
{


// -------------------------------------------------------------------------------------------------
//! GDI の HDC 操作用のラッパークラス.
//! 指定したハンドルのデバイスコンテキストを生成し、ハンドル、コンテキストを保持する.
class CHwndDC
{
public:
	CHwndDC(void)
		: m_hdc(NULL)
		, m_hwnd(NULL)
	{}

	virtual ~CHwndDC(void)
	{
		Release();
	}

	bool Init(HWND _hwnd)
	{
		if( m_hdc != NULL || m_hwnd != NULL )
			return false;

		HDC t_hdc = GetDC( _hwnd );
		if( t_hdc == NULL )
			return false;

		m_hdc  = t_hdc;
		m_hwnd = _hwnd;
		return true;
	}

	bool Release(void)
	{
		if( m_hdc == NULL )
			return false;

		if( ReleaseDC( m_hwnd , m_hdc ) != 1 )
			return false;

		m_hdc = NULL;
		m_hwnd = NULL;
		return true;
	}

	HDC  GetHDC(void)  const { return m_hdc  ; }
	HWND GetHWND(void) const { return m_hwnd ; }

	bool HasHDC(void)  const { return m_hdc  != NULL ; }
	bool HasHWND(void) const { return m_hwnd != NULL ; }

protected:
	HDC  m_hdc;
	HWND m_hwnd;
};



}
