import sys
import os

from VersionInfo import *


def GetEnv(name):
	return os.environ.get(name)

def MakeDefines(name, value):
	return ('#define %s "%s"' % (name, value))

def MakeDefine(name, value):
	return ('#define %s %s' % (name, value))

def WriteLine(f, str):
	f.write(str + '\n')

def CreateHeader(filepath):
	f = open(filepath, 'w')

	WriteLine(f, MakeDefines( 'BUILD_ID      ' , getBuildID()         ))
	WriteLine(f, MakeDefines( 'VERSION_MAJOR ' , getMajorVersion()    ))
	WriteLine(f, MakeDefines( 'VERSION_MINOR ' , getMinorVersion()    ))
	WriteLine(f, MakeDefines( 'BUILD_NUMBER  ' , getBuildNumber()     ))
	WriteLine(f, MakeDefines( 'VCS_REVISION  ' , getVCSRevision()     ))
	WriteLine(f, MakeDefines( 'SOURCE_HASH   ' , getGitRevisionFull() ))
	WriteLine(f, '')
	WriteLine(f, MakeDefine('BUILDMODE_RELEASE', 'true'))
	f.close()

def main():
	argv = sys.argv
	argc = len(argv)
	if argc != 2:
		print('Usage: ' + argv[0] + '[header_filepath]')
		return

	CreateHeader(argv[1])

main()
