#pragma once

#include <QString>
#include <QStringList>



class FileDlgFilter
{
public:
	FileDlgFilter(const QString& name_, const QString& ext_) :
		Name(name_),
		Ext(ext_)
	{
	}

public:
	QString Name;
	QString Ext;
};


class FileDlgFilterList
{
public:
	void Add(const QString& name_, const QString& ext_)
	{
		List.push_back(FileDlgFilter(name_, ext_));
	}

public:
	std::vector<FileDlgFilter> List;
};


class FileDlgUtil
{
public:
	static QString ExtListToDlgFilter(const QString& whole_name, const FileDlgFilterList& list);

private:
	static QString ToFilter(const QString& name, const QString& ext);
	static QString CreatAllTypeFilter(const QString& whole_name, const FileDlgFilterList& list);
};
