#pragma once

#include "GeomTexture.h"

#include <LibGeo/Mesh/BaseMesh.h>

#include <LibQtGeoViewerCore/Transform.h>



namespace gl
{


class EnvImage
{
public:
	EnvImage(void);

	void InitEnvMap(void);

	void Draw(float radius, const lm::vec3f& center);

	void ClearEnv(void);

	void LoadTexture(const char* filename);

	void BindTexture(void);

private:
	void ShowWire(void);
	void ShowTexture(void);


public:
	bool m_VisibleEnvSphere;
	bool m_IsEnableReflection;

	float m_EnvReflection;

private:
	lib_geo::BaseMesh       m_EnvSphere;
	gl::GlTexture           m_Tex;
	geom::TextureTransform  m_TexTrans;
};


}
