#include "stdafx.h"
#include "GeomReaderBuilder.h"

#include "Format/PmdLoader.h"
#include "Format/MqoLoader.h"
#include "Format/PlyLoader.h"
#include "Format/StlLoader.h"
#include "Format/DaeLoader.h"
#include "Format/ObjLoader.h"
#include "Format/XFileLoader.h"

using namespace geom;



GeomFileReader* GeomReaderBuilder::Create(geom::GeomFileFormat fmt)
{
	switch(fmt)
	{
	case GeomFileFormat::Obj     : return new ObjLoader();
	case GeomFileFormat::Stl     : return new StlLoader();
	case GeomFileFormat::Ply     : return new PlyLoader();
	case GeomFileFormat::Mqo     : return new MqoLoader();
	case GeomFileFormat::Collada : return new DaeLoader();
	case GeomFileFormat::Pmd     : return new PmdLoader();
	case GeomFileFormat::XFile   : return new XFileLoader();
	default:
		assert(false);
		return false;
	}
}
