#pragma once

#include <string>

#include "../GeomObject.h"
#include "../GeomFileFormat.h"

#include <assimp/vector3.h>
#include <assimp/matrix4x4.h>



class SceneMain;
struct aiScene;
struct aiNode;
struct aiMesh;
struct aiBone;
struct aiNodeAnim;


class AssimpReader
{
public:
	bool Load(SceneMain& scene, const std::string& filename, geom::GeomFileFormat fmt);

private:
	void SetNodeTree(const aiScene* ai_scene, geom::GeomObject* geom);
	void SetNodeTreeSub(const aiScene* ai_scene, const aiNode* an, geom::GeomObject* geom, geom::SceneNode* gn);

	void ResetBone(geom::MeshBuf* mbuf, aiMesh* mesh);
	void ConvertBoneWeight(const aiBone* s_bone, geom::Bone& d_bone);

	void SetBoneNodeRef(geom::NodeMap& nodemap, geom::GeomObject* geom);
	void LoadAnimation(geom::NodeMap& nodemap, const aiScene* ai_scene, geom::GeomObject* geom, bool Interpolate);

	int GetNumMinusKeyFrames(const aiNodeAnim* ch) const;

	void ReadKeys_Raw(aiNodeAnim* ch, geom::SceneNode* bn);
	void ReadKeys_Time(aiNodeAnim* ch, geom::SceneNode* bn, double FrameStep);

	int RoundF(double f);
	int ToFrame(double time, double TimeMin, double FrameStep);

	void PlotASNode(aiNode* n);
};
