import sys
import os

from IOUtil import *
from CollectLib import *


def makeDirs(OutDir):
	createPathIfnotExist(OutDir)
	createPathIfnotExist(OutDir + 'Data/')
	createPathIfnotExist('Res/')

def copyResources(OutDir):
	copyFiles('../QtGeoViewer/BuildInfo.h', 'Res/')
	copyFiles('../QtGeoViewer/Version.rc', 'Res/')
	createPathIfnotExist(OutDir + 'translations/')
	copyFiles('../QtGeoViewer/translations/*.qm', OutDir + 'translations/')

def copyBuildFiles(OutDir):
	InDir = '../Win32/Release/'
	copyFiles(InDir + '*.exe', OutDir)
	copyFiles(InDir + '*.dll', OutDir)
	copyFiles('../DependsLibraries.txt', OutDir)

def copyShaderDir(rootIn, rootOut, subName):
	createPathIfnotExist(rootOut + subName)
	copyFiles(rootIn + subName + '*.frag', rootOut + subName)
	copyFiles(rootIn + subName + '*.vert', rootOut + subName)

def copyResourcesDir(rootIn, rootOut, subName):
	createPathIfnotExist(rootOut + subName)
	copyFiles(rootIn + subName + '*.*', rootOut + subName)

def copyShader(OutDir):
	rootDir = 'ShaderCode/'
	rootOut = OutDir + rootDir
	rootIn = '../QtGeoViewer/' + rootDir
	createPathIfnotExist(rootOut)
	copyShaderDir(rootIn, rootOut, 'Mesh/')
	copyShaderDir(rootIn, rootOut, 'Postproc/')

def copyMatcap(OutDir):
	rootDir = 'Data/matcaps/'
	rootOut = OutDir + rootDir
	rootIn  = '../' + rootDir
	createPathIfnotExist(rootOut)
	copyResourcesDir(rootIn, rootOut, 'blender/')
	copyResourcesDir(rootIn, rootOut, 'Proton/')

def copyEnvmap(OutDir):
	rootDir = 'Data/Envmap/'
	rootOut = OutDir + rootDir
	rootIn  = '../' + rootDir
	createPathIfnotExist(rootOut)
	copyResourcesDir(rootIn, rootOut, 'sIBLArchive/')

def copyDefaultConfig(OutDir, isFullmode):
	configOut = OutDir + 'Data/DefaultConfig/'
	rootDir = '../Data/DefaultConfig/'
	createPathIfnotExist(configOut)
	copyFiles(rootDir + 'layout.dat', configOut)
	copyFiles(rootDir + 'window_layout.dat', configOut)
	if (isFullmode):
		copyFiles(rootDir + 'gui_config_full.xml', configOut + 'gui_config.xml')
	else:
		copyFiles(rootDir + 'gui_config.xml', configOut + 'gui_config.xml')

def copyVCRuntime(OutDir):
	VSAppDir = os.environ.get("VS110COMNTOOLS")
	VSDir = VSAppDir + '..\\..\\'
	Redist86 = VSDir + 'VC\\redist\\x86\\'
	copyFiles(Redist86 + 'Microsoft.VC110.CRT/msvcp110.dll', OutDir)
	copyFiles(Redist86 + 'Microsoft.VC110.CRT/msvcr110.dll', OutDir)

OutDir = 'Release/'

isFullmode = False
if (len(sys.argv) == 2):
	if (sys.argv[1] == "FULL"):
		isFullmode = True

print("FullMode : " + str(isFullmode))

makeDirs(OutDir)
copyResources(OutDir)
copyBuildFiles(OutDir)
copyShader(OutDir)
copyMatcap(OutDir)
copyEnvmap(OutDir)
copyDefaultConfig(OutDir, isFullmode)
copyQtLibs(OutDir)
copyVCRuntime(OutDir)
