#pragma once

#include <gdiplus.h>
#pragma comment(lib, "gdiplus.lib")


namespace lib_graph
{


//! GDI+̏T|[gNX
class GdiplusInitializer
{
public:
	GdiplusInitializer(void)
		: m_Initialized(false)
	{}

	virtual ~GdiplusInitializer(void)
	{
		if( m_Initialized )
		{
			FinalizeGDIPlus();
		}
	}


	bool InitializeGDIPlus(void)
	{
		const Gdiplus::GdiplusStartupInput default_input;
		return InitializeGDIPlus( default_input , NULL );
	}

	bool InitializeGDIPlus( const Gdiplus::GdiplusStartupInput& startup_input , Gdiplus::GdiplusStartupOutput* output_ptr )
	{
		_ASSERTE( !m_Initialized );
		if( m_Initialized )
			return false;

		m_GdiStartupInput = startup_input;

		Gdiplus::Status status;
		status = Gdiplus::GdiplusStartup( &m_GdiToken , &m_GdiStartupInput , output_ptr );
		_ASSERTE( status == Gdiplus::Ok );
		if( status != Gdiplus::Ok )
			return false;

		m_Initialized = true;
		return true;
	}

	bool FinalizeGDIPlus(void)
	{
		_ASSERTE( m_Initialized );
		if( !m_Initialized )
			return false;

		Gdiplus::GdiplusShutdown( m_GdiToken );

		m_Initialized = false;
		return true;
	}

	bool IsInitialized(void) const
	{
		return m_Initialized;
	}

	const Gdiplus::GdiplusStartupInput& GetStartupInput(void) const
	{
		return m_GdiStartupInput;
	}

	
private:
	ULONG_PTR                    m_GdiToken;
	Gdiplus::GdiplusStartupInput m_GdiStartupInput;

	bool m_Initialized;
};


}
