attribute vec3 Tangent;

varying vec3 v_positionSrc;
varying vec3 v_position;
varying vec3 v_normal;
varying vec3 v_tangent;

uniform mat4 shadow_mat;

varying vec4 v_shadow_pos;

varying vec3 v_ref_view;
varying vec3 v_ref_normal;

uniform mat4 scene_mat;



void main(void)
{
	v_positionSrc = gl_Vertex.xyz / gl_Vertex.w;
	v_position    = vec3(gl_ModelViewMatrix * gl_Vertex);
	v_normal      = normalize(gl_NormalMatrix * gl_Normal);
	v_tangent     = normalize(gl_NormalMatrix * Tangent);

	v_ref_view.x = gl_ModelViewMatrixInverse[3].x;
	v_ref_view.y = gl_ModelViewMatrixInverse[3].y;
	v_ref_view.z = gl_ModelViewMatrixInverse[3].z;
	v_ref_view = normalize(v_ref_view - gl_Vertex.xyz / gl_Vertex.w);

	vec4 t = scene_mat * vec4(v_ref_view.x, v_ref_view.y, v_ref_view.z, 1.0);
	v_ref_view = vec3(t.x, t.y, t.z);

	vec4 nt = scene_mat * vec4(gl_Normal.x, gl_Normal.y, gl_Normal.z, 1.0);
	vec3 ntt = vec3(nt.x, nt.y, nt.z) / nt.w;

	v_ref_normal = ntt;

	//v_ref_normal = gl_Normal;

	v_shadow_pos = shadow_mat * gl_Vertex;

	gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;

	gl_Position = ftransform();

	gl_FrontColor = gl_Color;

	gl_ClipVertex = gl_ModelViewMatrix * gl_Vertex;
}
