#include "stdafx.h"
#include "Selection3D.h"
#include "MeshBuf.h"
#include "GeomObject.h"


Selection3D::Selection3D(void)
{
	m_SelObjectIdx = -1;
	m_SelMeshIdx = -1;
}

void Selection3D::ClearSelect(void)
{
	m_SelObjectIdx = -1;
	m_SelMeshIdx = -1;
}

bool Selection3D::IsObjectSelected(void) const
{
	return m_SelObjectIdx != -1;
}

int Selection3D::GetSelObjectIdx(void) const
{
	return m_SelObjectIdx;
}

bool Selection3D::IsSelectedMBuf(int mbuf_idx) const
{
	if (mbuf_idx == m_SelObjectIdx)
		return true;

	if (!IsMBufSelected())
	{
		if (mbuf_idx == 0)
			return true;
	}

	return false;
}

bool Selection3D::IsMBufSelected(void) const
{
	return m_SelMeshIdx != -1;
}

int Selection3D::GetMBufIdx(void) const
{
	return m_SelMeshIdx;
}

void Selection3D::SelectObject(int obj_idx)
{
	m_SelObjectIdx = obj_idx;
	m_SelMeshIdx = -1;
}

void Selection3D::SelectMBuf(int obj_idx, int mbuf_idx)
{
	m_SelObjectIdx = obj_idx;
	m_SelMeshIdx = mbuf_idx;
}

bool Selection3D::IsInSelects(const geom::MeshBuf& mbuf)
{
	if (m_SelObjectIdx != mbuf.GetParent()->GetObjectIndex())
		return false;

	if (IsMBufSelected())
	{
		if (m_SelMeshIdx != mbuf.m_MBufIdx)
			return false;
	}

	return true;
}
