#pragma once

#include <QWidget>
#include "ui_WidgetCamera.h"



class FormMain;

class WidgetCamera : public QWidget
{
	Q_OBJECT

public:
	WidgetCamera(QWidget *parent = 0);
	~WidgetCamera();

	void setMainForm(FormMain* mainFrm_);

	void focusList();

	bool OpenCameraFile(const QString& path);

private slots:
	void on_pushButtonAddCameraRecord_clicked();
	void on_pushButtonDeleteCameraRecord_clicked();
	void on_checkCameraAnimation_toggled(bool checked);
	void on_pushCameraRecordClear_clicked();

	void on_listCamera_itemDoubleClicked(QListWidgetItem *item);
	void on_checkEnableCamerSeq_toggled(bool checked);

	void on_buttonLoadCameraSeq_clicked();
	void on_buttonClearCameraSeq_clicked();

private:
	Ui::WidgetCamera ui;

	FormMain* mainFrm;
};
