#pragma once

#include <memory>


class PostprocInterface;
class PostprocContext;

class NullPostproc;
class AntialiasPostproc;
class BorderPostproc;
class DepthLayerColorPostproc;
class DepthColorPostproc;
class DepthOfFieldPostproc;



enum class PostProcType
{
	None,
	Antialias,
	Border,
	DepthLayerColor,
	DepthColor,
	DepthOfField,
};


class PosprocLibrary
{
public:
	PosprocLibrary(PostprocContext* context) :
		m_Context(context)
	{
	}

	PostprocInterface* GetOrCreatePostproc(PostProcType type);

	AntialiasPostproc*       GetAntialias(void);
	BorderPostproc*          GetBorder(void);
	DepthLayerColorPostproc* GetDepthLayerColor(void);
	DepthColorPostproc*      GetDepthColor(void);
	DepthOfFieldPostproc*    GetDepthOfField(void);

private:
	PostprocContext* m_Context;

	std::shared_ptr< AntialiasPostproc       > m_Antialias;
	std::shared_ptr< BorderPostproc          > m_Border;
	std::shared_ptr< DepthLayerColorPostproc > m_DepthLayerColor;
	std::shared_ptr< DepthColorPostproc      > m_DepthColor;
	std::shared_ptr< DepthOfFieldPostproc    > m_DepthOfField;
};
