#include "stdafx.h"

#include "QtSingleApplication.h"
#include "QtLocalPeer.h"

#include <QWidget>


void QtSingleApplication::sysInit(const QString &appId)
{
	actWin = 0;
	peer = new QtLocalPeer(this, appId);
	connect(peer, SIGNAL(messageReceived(const QString&)), SIGNAL(messageReceived(const QString&)));
}


QtSingleApplication::QtSingleApplication(int &argc, char **argv, bool GUIenabled)
	: QApplication(argc, argv, GUIenabled)
{
	sysInit();
}

QtSingleApplication::QtSingleApplication(const QString &appId, int &argc, char **argv)
	: QApplication(argc, argv)
{
	sysInit(appId);
}

#if QT_VERSION < 0x050000

QtSingleApplication::QtSingleApplication(int &argc, char **argv, Type type)
	: QApplication(argc, argv, type)
{
	sysInit();
}

#endif // QT_VERSION < 0x050000


bool QtSingleApplication::isRunning()
{
	return peer->isClient();
}

bool QtSingleApplication::sendMessage(const QString &message, int timeout)
{
	return peer->sendMessage(message, timeout);
}

QString QtSingleApplication::id() const
{
	return peer->applicationId();
}

void QtSingleApplication::setActivationWindow(QWidget* aw, bool activateOnMessage)
{
	actWin = aw;
	if (activateOnMessage)
		connect(peer, SIGNAL(messageReceived(const QString&)), this, SLOT(activateWindow()));
	else
		disconnect(peer, SIGNAL(messageReceived(const QString&)), this, SLOT(activateWindow()));
}

QWidget* QtSingleApplication::activationWindow() const
{
	return actWin;
}

void QtSingleApplication::activateWindow()
{
	if (actWin) {
		actWin->setWindowState(actWin->windowState() & ~Qt::WindowMinimized);
		actWin->raise();
		actWin->activateWindow();
	}
}
