
/*
*************************************************************************************************

OpenCVˑ̃eNX`NX

*************************************************************************************************
*/


#pragma once

#include <cassert>

#include "OpenCVTextureSetter.h"

#include "../../graph/OpenCVImage.h"



namespace lib_gl
{


//! CvImage^eNX`NX
class CvTexture : public lgr::CvImage
{
public:
	CvTexture(void)
		: CvImage()
	{}

	CvTexture( const CvTexture& i_tex )
		: CvImage( i_tex )
	{}

	CvTexture( const CvImage& i_img )
		: CvImage( i_img )
	{}


	virtual const CvTexture& operator=( const CvTexture& i_tex )
	{
		this->CvImage::operator=( i_tex );
		return *this;
	}


	void SetGLTexture( lib_gl::TEXTURE_MODE tex_mode = lib_gl::TEXTURE_NORMAL ) const;
};



//! OpenGL̃JgeNX`XV.
inline void CvTexture::SetGLTexture( lib_gl::TEXTURE_MODE tex_mode ) const
{
	_ASSERT( m_Image != NULL );
	if( m_Image == NULL )
		return;

	lib_gl::SetCVTexture( m_Image , tex_mode );
}


}
