-- データの保存
-- Satofumi KAMIMURA
-- $Id: save_sample.lua 716 2009-04-06 22:10:16Z satofumi $


function save_item(name)

   -- ここで変数の内容を評価して value に代入する
   local value = assert(loadstring("return " .. name))()

   if type(value) == "boolean" then
      -- boolean のときは、手動で文字列に変換する
      if value then
         value = "true"
      else
         value = "false"
      end
   else if type(value) == "string" then
         -- 文字列の前後に \" を付加する
         value = string.format("\"%s\"", value)
      end
   end

   return name .. " = " .. value .. "\n"
end


function save(file)

   local fd = assert(io.open(file, "wb"))

   -- 各変数の保存
   local buffer = ""
   buffer = buffer .. save_item("_G.user_name")
   buffer = buffer .. save_item("_G.life")
   buffer = buffer .. save_item("_G.flag")

   -- 拡張子が .lc だったら、バイナリ形式に変換する
   if string.sub(file, -3) == ".lc" then
      buffer = string.dump(assert(loadstring(buffer)))
   end

   fd:write(buffer)
   fd:close()
end


-- 保存したい内容 (本来この内容は、システム内で設定される)
-- また、上記の関数は save.lua などの別ファイルにしておき
-- require("savel.lua") などとして使うべき
_G.user_name = "guest"
_G.life = 3
_G.flag = true

save("save_data.lua")
save("save_data.lc")
