/*!
  \example dostring.cpp
  \brief Lua スクリプトの実行サンプル

  \author Satofumi KAMIMURA

  $Id: dostring.cpp 704 2009-04-01 20:49:25Z satofumi $
*/

#include <lua.hpp>
#include <string>
#include <iostream>

using namespace std;


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  // Lua の初期化
  lua_State* lua = lua_open();
  luaL_openlibs(lua);

  // Lua スクリプトを直接実行
  if (luaL_dostring(lua, "print(\"hello\")")) {
    // エラー時のメッセージ表示
    string error_message = lua_tostring(lua, -1);
    cout << "luaL_dofile: " << error_message << endl;
    exit(1);
  }

  return 0;
}
