/*!
  \example bindCpp.cpp
  \brief C++ 関数をバインドするサンプル

  \author Satofumi KAMIMURA

  $Id: bindCpp.cpp 704 2009-04-01 20:49:25Z satofumi $
*/

#include "luabindSystem.h"
#include "LuaHandler.h"
#include <cstdlib>

using namespace qrk;


int main(int argc, char *argv[])
{
  if (argc <= 1) {
    printf("usage:\n"
           "\t%s <lua script>\n", argv[0]);
    exit(0);
  }
  const char* lua_script = argv[1];

  // C++ クラス、関数のバインド
  luabindSystem();

  // １つ上のパスを Lua の実行パスに追加
  LuaHandler::doString("package.path = \"../?.lua\"");

  // 引数で渡されたスクリプトの実行
  return LuaHandler::doFile(lua_script);
}
