/*!
  \file
  \brief Joystick 情報の表示

  \author Satofumi KAMIMURA

  $Id: ViewJoystickInfo.cpp 774 2009-05-05 08:02:57Z satofumi $
*/

#include "ViewJoystickInfo.h"
#include "mUsbJoystick.h"
#include "SdlInit.h"
#include "delay.h"
#include <cstdio>

using namespace qrk;


/*!
  \brief SdlInit の初期化クラス
*/
class SdlInitClass : private SdlInit
{
};


static bool printJoystickInput(mUsbJoystick& joystick,
                               size_t axis_num, size_t buttons_num)
{
  bool haveInput = false;

  for (size_t i = 0; i < axis_num; ++i) {
    short value = joystick.axisValue(i);
    printf("%d,", value);
    if (value != 0) {
      haveInput = true;
    }
  }

  for (size_t i = 0; i < buttons_num; ++i) {
    bool pressed = joystick.isButtonPressed(i);
    printf("%c,", (pressed) ? '*' : '_');
    if (pressed != false) {
      haveInput = true;
    }
  }
  putchar('\n');

  return haveInput;
}


void ViewJoystickInfo(mUsbJoystick& joystick)
{
  static SdlInitClass obj;

  size_t axis_num = joystick.numAxis();
  size_t buttons_num = joystick.numButtons();

  // 入力情報の出力
  Uint32 lastInputTicks = SDL_GetTicks();
  while (1) {
    // ５秒以上、ボタン入力がなければ終了する
    if (SDL_GetTicks() - lastInputTicks > 5000) {
      break;
    }

    // ジョイスティックへの入力情報を表示
    SDL_Event event;
    while (SDL_PollEvent(&event)) {
      joystick.setEvent(event);
    }
    if (printJoystickInput(joystick, axis_num, buttons_num)) {
      lastInputTicks = SDL_GetTicks();
    }

    // 入力を表示
    delay(200);
  }
}
