#ifndef QRK_USB_JOYSTICK_H
#define QRK_USB_JOYSTICK_H

/*!
  \file
  \brief USB ジョイスティック

  \author Satofumi KAMIMURA

  $Id: UsbJoystick.h 783 2009-05-05 08:56:26Z satofumi $

  \attention 動作するためには、SDL の画面が開かれている必要がある。
*/

#include <SDL.h>
#include <memory>


namespace qrk
{
  /*!
    \brief USB ジョイスティック入力の取得クラス
  */
  class UsbJoystick
  {
    UsbJoystick(const UsbJoystick& rhs);
    UsbJoystick& operator = (const UsbJoystick& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    UsbJoystick(void);
    ~UsbJoystick(void);

    const char* what(void);


    /*!
      \brief ジョイスティック数を返す

      \retrun 認識しているジョイスティック数を返す
    */
    static size_t joystickNum(void);

    void setEvent(SDL_Event& event);

    enum {
      Auto = -1,           //!< 接続時に自動的にインデックスを選択する
    };


    /*!
      \brief 接続

      \param index [i] 接続処理を行うインデックス番号

      \retval true 接続成功
      \retval false 接続に失敗
    */
    bool connect(int index = Auto);


    /*!
      \brief 切断
    */
    void disconnect(void);


    /*!
      \brief 接続状態を返す

      \retval true 接続中
      \retval false 切断中
    */
    bool isConnected(void);

    const char* productInfo(void);

    size_t numAxis(void);
    size_t numButtons(void);
    short axisValue(size_t index);
    bool isButtonPressed(size_t index);
  };
}

#endif /* !QRK_USB_JOYSTICK_H */
