#ifndef M_CONNECTION_H
#define M_CONNECTION_H

/*!
  \file
  \brief j^Ή̒ʐMC^[tF[X

  \author Satofumi KAMIMURA

  $Id: mConnection.h 212 2008-09-04 03:48:22Z satofumi $
*/

#include "Connection.h"
#include <memory>


namespace qrk
{
  /*!
    \brief j^Ή̒ʐMC^[tF[X
  */
  class mConnection : public Connection
  {
    mConnection(void);
    mConnection(const mConnection& rhs);
    mConnection& operator = (const mConnection& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    explicit mConnection(Connection* connection);
    ~mConnection(void);

    const char* what(void);

    bool connect(const char* device, long baudrate);
    void disconnect(void);
    bool setBaudrate(long baudrate);
    long baudrate(void);
    bool isConnected(void);
    int send(const char* data, size_t count);
    int recv(char* data, size_t count, int timeout);
    size_t size(void);
    void flush(void);
    void clear(void);
    void ungetc(const char ch);
  };
}

#endif /* !CONNECTION_H */
