#ifndef URG_UTILS_H
#define URG_UTILS_H

/*!
  \file
  \brief URG ̕⏕֐

  \author Satofumi KAMIMURA

  $Id: UrgUtils.h 529 2009-01-30 13:32:22Z satofumi $
*/

#include <cstdlib>


namespace qrk
{
  /*!
    \brief VA ID ̎擾

    \param[in] urg urg IuWFNg

    \retval >= VA ID
    \retval <0 G[
  */
  template <class T>
  long urgSerialId(T* urg)
  {
    std::vector<std::string> version_lines;
    if (! urg->versionLines(version_lines)) {
      return -1;
    }
    if (version_lines.size() < 5) {
      return -1;
    }

    std::string& serial_line = version_lines[4];
    if (serial_line.size() < 7) {
      return -1;
    }
    return atol(serial_line.substr(6).c_str());
  }


  // !!! UrgCtrl ̃IuWFNg swap ev[g`
}

#endif /* !URG_UTILS_H */
