#ifndef TCPIP_SERVER_H
#define TCPIP_SERVER_H

/*!
  \file
  \brief TCP/IP ̃T[o

  \author Satofumi KAMIMURA

  $Id: TcpipServer.h 439 2009-01-03 05:01:55Z satofumi $
*/

#include "Connection.h"
#include <memory>


namespace qrk
{
  class TcpipServer : public Connection
  {
    TcpipServer(const TcpipServer& rhs);
    TcpipServer& operator = (const TcpipServer& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      NoTimeout = -1,
    };
    TcpipServer(void);
    ~TcpipServer(void);

    const char* what(void);

    bool activate(long port);
    void deactivate(void);
    bool accept(int timeout = NoTimeout);

    bool connect(const char* host, long port);
    void disconnect(void);
    bool setBaudrate(long baudrate);
    long baudrate(void);
    bool isConnected(void);
    int send(const char* data, size_t count);
    int recv(char* data, size_t count, int timeout);
    size_t size(void);
    void flush(void);
    void clear(void);
    void ungetc(const char ch);
  };
}

#endif /* !TCPIP_SERVER_H */
