#ifndef SERIAL_CTRL_H
#define SERIAL_CTRL_H

/*!
  \file
  \brief VAʐM

  \author Satofumi KAMIMURA

  $Id: SerialCtrl.h 439 2009-01-03 05:01:55Z satofumi $
*/

#include "Connection.h"
#include <memory>


namespace qrk
{
  /*!
    \brief VAʐMNX
  */
  class SerialCtrl : public Connection
  {
    SerialCtrl(const SerialCtrl& rhs);
    SerialCtrl& operator = (const SerialCtrl& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      DefaultBaudrate = 115200,
    };
    SerialCtrl(void);
    ~SerialCtrl(void);

    const char* what(void);

    bool connect(const char* device, long baudrate = DefaultBaudrate);
    void disconnect(void);
    bool setBaudrate(long baudrate);
    long baudrate(void);
    bool isConnected(void);
    int send(const char* data, size_t count);
    int recv(char* data, size_t count, int timeout);
    size_t size(void);
    void flush(void);
    void clear(void);
    void ungetc(const char ch);
  };
}

#endif /* !SERIAL_CTRL_H */
