#ifndef RING_BUFFER_H
#define RING_BUFFER_H

/*!
  \file
  \brief Oobt@

  \author Satofumi KAMIMURA

  $Id: RingBuffer.h 488 2009-01-21 03:33:51Z satofumi $
*/

#include <vector>
#include <cstring>


namespace qrk
{
  /*!
    \brief Oobt@
  */
  template <class T>
  class RingBuffer
  {
    RingBuffer(const RingBuffer& rhs);
    RingBuffer& operator = (const RingBuffer& rhs);

    std::vector<T> ring_buffer_;
    size_t buffer_size_;
    size_t first_;
    size_t last_;


    size_t free_size(void)
    {
      return buffer_size_ -1 - size();
    }


    void extendBuffer(long additional_size)
    {
      size_t extend_size = (buffer_size_ == 0) ? 1 : buffer_size_;
      size_t pre_extend_size = extend_size;
      while (additional_size > 0) {
        if (extend_size <= 1) {
          extend_size = 2;
        } else {
          extend_size = static_cast<size_t>(extend_size * 1.5);
        }
        additional_size -= static_cast<int>(extend_size - pre_extend_size);
        pre_extend_size = extend_size;
      }
      ring_buffer_.resize(extend_size);

      // gTCYɍ킹ăf[^ړ
      if (first_ > last_) {
        size_t to_end = extend_size - buffer_size_;
        size_t move_size = (to_end > last_) ? last_ : to_end;
        // 0  last ܂ł̃f[^Abuffer_size ȍ~Ɉړ
        memmove(&ring_buffer_[buffer_size_],
                &ring_buffer_[0], move_size * sizeof(T));

        // ړłȂf[^ 0 ̈ʒuɈړ
        size_t left_size = last_ - move_size;
        if (left_size == 0) {
          last_ += buffer_size_;
        } else {
          memmove(&ring_buffer_[0],
                  &ring_buffer_[move_size], left_size * sizeof(T));
          last_ = left_size;
        }
      }
      buffer_size_ = extend_size;
    }

  public:
    /*!
      \brief obt@TCYw̃RXgN^

      Ŏw肵TCYȏ̃obt@mۂ

      \param[in] defaultSize obt@TCY
    */
    explicit RingBuffer(size_t defaultSize = 0)
      : buffer_size_(2), first_(0), last_(0)
    {
      while (buffer_size_ < defaultSize) {
        buffer_size_ = static_cast<size_t>(buffer_size_ * 1.5);
      }
      ring_buffer_.resize(buffer_size_);
    }


    /*!
      \brief obt@TCY̎擾
    */
    size_t size(void)
    {
      return (last_ >= first_) ?
        (last_ - first_) : (buffer_size_ - (first_ - last_));
    }


    /*!
      \brief obt@

      \retval true f[^Ȃ
      \retval false f[^
    */
    bool empty(void)
    {
      return (first_ == last_) ? true : false;
    }


    /*!
      \brief f[^̊i[

      \param[in] data f[^
      \param[in] size f[^
    */
    void put(const T* data, size_t size)
    {
      long additional_size = static_cast<long>(size - free_size());
      if (additional_size > 0) {
        // obt@ɓ肫ȂꍇAg
        extendBuffer(additional_size);
      }

      // f[^zu
      if (first_ <= last_) {
        // last  buffer_size I[܂łɔzu
        size_t to_end = buffer_size_ - last_;
        size_t move_size = (to_end > size) ? size : to_end;
        memmove(&ring_buffer_[last_], data, move_size * sizeof(T));
        last_ += move_size;
        last_ %= buffer_size_;

        long left_size = static_cast<long>(size - move_size);
        if (left_size > 0) {
          // 0  first ̑O܂łzu
          memmove(&ring_buffer_[0], &data[move_size], left_size * sizeof(T));
          last_ = left_size;
        }
      } else {
        // last  first ̑O܂Ŕzu
        memmove(&ring_buffer_[last_], data, size * sizeof(T));
        last_ += size;
      }
    }


    /*!
      \brief f[^̎o

      \param[out] data f[^opobt@
      \param[in] size of[^̍ő

      \return of[^
    */
    size_t get(T* data, size_t size)
    {
      // f[^擾
      size_t return_size = (size <= this->size()) ? size : this->size();

      if (first_ <= last_) {
        memmove(data, &ring_buffer_[first_], return_size * sizeof(T));
        first_ += return_size;
      } else {
        // first  buffer_size I[܂łzu
        size_t to_end = buffer_size_ - first_;
        size_t move_size = (to_end > return_size) ? return_size : to_end;
        memmove(data, &ring_buffer_[first_], move_size * sizeof(T));
        first_ += move_size;
        first_ %= buffer_size_;

        long left_size = static_cast<long>(return_size - move_size);
        if (left_size > 0) {
          // 0  last ̑O܂łzu
          memmove(&data[move_size], &ring_buffer_[0], left_size * sizeof(T));
          first_ = left_size;
        }
      }
      return return_size;
    }


    /*!
      \brief f[^̏߂

      \param[in] ch ߂f[^
    */
    void ungetc(const char ch)
    {
      if (free_size() <= 0) {
        // ̈悪sĂAobt@TCYg
        extendBuffer(1);
      }

      // ̒ǉ
      first_ = (first_ == 0) ? (buffer_size_ - 1) : (first_ - 1);
      ring_buffer_[first_] = ch;
    }


    /*!
      \brief i[f[^̃NA
    */
    void clear(void)
    {
      first_ = 0;
      last_ = 0;
    }
  };
}

#endif /* !RING_BUFFER_H */
