#ifndef RANGE_SENSOR_PARAMETER_H
#define RANGE_SENSOR_PARAMETER_H

/*!
  \file
  \brief WZT̃p[^Ǘ

  \author Satofumi KAMIMURA

  $Id: RangeSensorParameter.h 439 2009-01-03 05:01:55Z satofumi $
*/

#include <string>


namespace qrk
{
  /*!
    \brief ZTp[^ǗNX
  */
  class RangeSensorParameter
  {
  public:
    enum {
      MODL = 0,                 //!< ZT^
      DMIN,                     //!< ŏv\ [mm]
      DMAX,                     //!< őv\ [mm]
      ARES,                     //!< px\(360x̕)
      AMIN,                     //!< ŏv\l
      AMAX,                     //!< őv\l
      AFRT,                     //!< ʕl
      SCAN,                     //!< Wpx
    };

    std::string model;          //!< 擾 MODL 
    long distance_min;          //!< 擾 DMIN 
    long distance_max;          //!< 擾 DMAX 
    int area_total;             //!< 擾 ARES 
    int area_min;               //!< 擾 AMIN 
    int area_max;               //!< 擾 AMAX 
    int area_front;             //!< 擾 AFRT 
    int scan_rpm;               //!< 擾 SCAN 

    RangeSensorParameter(void)
      : model(""), distance_min(0), distance_max(0), area_total(0),
        area_min(0), area_max(0), area_front(0), scan_rpm(600)
    {
    }
  };
}

#endif /* !RANGE_SENSOR_PARAMETER_H */
