#ifndef RANGE_SENSOR_H
#define RANGE_SENSOR_H

/*!
  \file
  \brief WZT̃C^[tF[X`

  \author Satofumi KAMIMURA

  $Id: RangeSensor.h 530 2009-01-30 14:57:15Z satofumi $
*/

#include "RangeCaptureMode.h"
#include "MathUtils.h"
#include <vector>
#include <string>


namespace qrk
{
  class Connection;
  class RangeSensorParameter;


  /*!
    \brief ZTEC^[tF[X
  */
  class RangeSensor
  {
  public:
    virtual ~RangeSensor(void) {}


    /*!
      \brief ԂԂ

      \return Ԃ

      <strong>Example</strong>
\code
UrgCtrl sensor;
if (! sensor.connect(device, baudrate)) {
  // ڑɎsƂɁAG[bZ[W\
  printf("connect: %s\n", sensor.what());
  exit(1);
} \endcode
    */
    virtual const char* what(void) const = 0;


    /*!
      \brief ڑ

      \param[in] device ڑfoCX
      \param[in] baudrate ڑ{[[g

      \retval true 
      \retval false s

      <strong>Example</strong>
\code
const char device[] = "/dev/ttyACM0";
const long baudrate = 115200;
UrgCtrl sensor;

// wfoCXɐڑ
if (! sensor.connect(device, baudrate)) {
  printf("connect: %s\n", sensor.what());
  exit(1);
} \endcode
    */
    virtual bool connect(const char* device, long baudrate) = 0;


    /*!
      \brief ڑIuWFNg̎w

      \param[in] con ڑIuWFNg
    */
    virtual void setConnection(Connection* con) = 0;


    /*!
      \brief ڑIuWFNg̎擾

      \return ڑIuWFNg
    */
    virtual Connection* connection(void) = 0;


    /*!
      \brief ؒf
    */
    virtual void disconnect(void) = 0;


    /*!
      \brief ڑԂԂ

      \retval true ڑ
      \retval false ؒf
    */
    virtual bool isConnected(void) const = 0;


    /*!
      \brief L̍ŏl擾

      \return L̍ŏl
    */
    virtual long minDistance(void) const = 0;


    /*!
      \brief L̍ől擾

      \return L̍ől
    */
    virtual long maxDistance(void) const = 0;


    /*!
      \brief P̍őXL

      \return P̍őXL
    */
    virtual int maxScanLines(void) const = 0;

    virtual int scanMsec(void) const = 0;

    virtual void setCaptureMode(RangeCaptureMode mode) = 0;
    virtual RangeCaptureMode captureMode(void) = 0;


    /*!
      \brief f[^擾

      f[^擾sAobt@Ɋi[

      \param[out] data 擾f[^pobt@
      \param[out] timestamp ^CX^v

      \return 擾f[^
      \retval <0 擾s
    */
    virtual int capture(std::vector<long>& data, long* timestamp) = 0;


    virtual int captureWithIntensity(std::vector<long>& data,
                                     std::vector<long>& intensity_data,
                                     long* timestamp) = 0;


    /*!
      \brief ZTԂ^CX^vl̐ݒ

      capture() Ŏ擾ł^CX^vݒ肷

      \param[in] ticks ̎̃^CX^v̐ݒl
      \param[out] response_msec bZ[W̑Mɗv [msec]
      \param[in] force_delay_msec IɎw肷x

      \retval true 
      \retval false s
    */
    virtual bool setTimestamp(int ticks = 0, int* response_msec = NULL,
                              int* force_delay_msec = NULL) = 0;


    /*!
      \brief ŐṼ^CX^vl

      \return ^CX^vl
    */
    virtual long recentTimestamp(void) const
    {
      return 0;
    }


    virtual bool setLaserOutput(bool on) = 0;


    /*!
      \brief f[^CfbNX radian pxϊ

      ZTOʂA0.0 [rad] ɑB

      \param[in] index f[^CfbNX

      \return px [radian]

      \image html sensor_radian.png ZTʂ̊pxΉ}

      \see index2deg(), rad2index(), deg2index()
    */
    virtual double index2rad(const int index) const = 0;


    /*!
      \brief f[^CfbNX degree pxϊ

      ZTOʂA0.0 [rad] ɑB

      \param[in] index f[^CfbNX

      \return px [degree]

      \image html sensor_radian.png ZTʂ̊pxΉ}

      \see index2rad(), rad2index(), deg2index()
    */
    int index2deg(const int index) const
    {
      return static_cast<int>(floor((180.0 * index2rad(index) / M_PI) + 0.5));
    }


    /*!
      \brief radian px̃f[^CfbNXϊ

      ZTOʂA0.0 [rad] ɑB

      \param[in] radian px [radian]

      \return f[^CfbNX

      \see deg2index(), index2rad(), index2deg()
    */
    virtual int rad2index(const double radian) const = 0;


    /*!
      \brief f[^CfbNX̊pxϊ

      ZTOʂA0.0 [rad] ɑB

      \param[in] degree px [degree]

      \return px [degree]

      \see rad2index(), index2rad(), index2deg()
    */
    int deg2index(const int degree) const
    {
      return rad2index(degree * M_PI / 180.0);
    }


    /*!
      \brief URG p[^̍XV

      \param[in] parameter XV URG p[^
    */
    virtual void setParameter(const RangeSensorParameter& parameter) = 0;


    /*!
      \brief URG p[^̎擾

      \return URG p[^
    */
    virtual RangeSensorParameter parameter(void) const = 0;
  };
}

#endif /* !RANGE_SENSOR_H */
