#ifndef POSITION_TYPES_H
#define POSITION_TYPES_H

/*!
  \file
  \brief ʒu(Wƌ)̌^`

  WƌǗ

  \author Satofumi KAMIMURA

  $Id: PositionTypes.h 439 2009-01-03 05:01:55Z satofumi $

  \todo Grid,T> pׂ
*/

#include "AngleTypes.h"


namespace qrk
{
  /*!
    \brief ʒu
  */
  template<class T> class Position
  {
  public:
    T x;                        //!< X ʒu
    T y;                        //!< Y ʒu
    Angle angle;                //!< px


    Position(void) : x(0), y(0)
    {
    }


    Position(const Position& rhs) : x(rhs.x), y(rhs.y), angle(rhs.angle)
    {
    }


    Position(T x_, T y_, const Angle& angle_) : x(x_), y(y_), angle(angle_)
    {
    }


    bool operator == (const Position& rhs)
    {
      if ((this->x == rhs.x) && (this->y == rhs.y) &&
          (this->angle.to_rad() == rhs.angle.to_rad())) {
        return true;
      } else {
        return false;
      }
    }


    Position& operator = (const Position& rhs)
    {
      this->x = rhs.x;
      this->y = rhs.y;
      this->angle = rhs.angle;

      return *this;
    }

    Position<T>& operator += (const Position<T>& rhs)
    {
      this->x += rhs.x;
      this->y += rhs.y;
      this->angle += rhs.angle;

      return *this;
    }


    const Position<T> operator + (const Position<T>& rhs) const
    {
      return Position<T>(*this) += rhs;
    }


    Position<T>& operator -= (const Position<T>& rhs)
    {
      this->x -= rhs.x;
      this->y -= rhs.y;
      this->angle -= rhs.angle;

      return *this;
    }


    const Position<T> operator - (const Position<T>& rhs) const
    {
      return Position<T>(*this) -= rhs;
    }


    Position<T>& operator *= (const T& rhs)
    {
      this->x *= rhs;
      this->y *= rhs;
      this->angle *= rhs.angle;

      return *this;
    }


    Position<T> operator * (const T& rhs) const
    {
      Position<T> ret(*this);
      return ret *= rhs;
    }


    friend const Position<T> operator * (const T& lhs, const Position<T>& rhs)
    {
      return Position<T>(rhs) * lhs;
    }


    int to_deg(void) const
    {
      return angle.to_deg();
    }


    double to_rad(void) const
    {
      return angle.to_rad();
    }
  };
}

#endif /* !POSITION_TYPES_H */
